/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQObjectMessage;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.wireformat.WireFormat;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4893Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ4893Test.class);

    @Test
    public void testPropertiesInt() throws Exception {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setIntProperty("TestProp", 333);
        this.fakeUnmarshal(message);
        this.roundTripProperties(message);
    }

    @Test
    public void testPropertiesString() throws Exception {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setStringProperty("TestProp", "Value");
        this.fakeUnmarshal(message);
        this.roundTripProperties(message);
    }

    @Test
    public void testPropertiesObject() throws Exception {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setObjectProperty("TestProp", (Object)"Value");
        this.fakeUnmarshal(message);
        this.roundTripProperties(message);
    }

    @Test
    public void testPropertiesObjectNoMarshalling() throws Exception {
        ActiveMQObjectMessage message = new ActiveMQObjectMessage();
        message.setObjectProperty("TestProp", (Object)"Value");
        this.roundTripProperties(message);
    }

    private void roundTripProperties(ActiveMQObjectMessage message) throws IOException, JMSException {
        ActiveMQObjectMessage copy = new ActiveMQObjectMessage();
        for (Map.Entry prop : message.getProperties().entrySet()) {
            LOG.debug("{} -> {}", prop.getKey(), prop.getValue().getClass());
            copy.setObjectProperty((String)prop.getKey(), prop.getValue());
        }
    }

    private void fakeUnmarshal(ActiveMQObjectMessage message) throws IOException {
        OpenWireFormat format = new OpenWireFormat();
        message.beforeMarshall((WireFormat)format);
        message.afterMarshall((WireFormat)format);
        ByteSequence seq = message.getMarshalledProperties();
        message.clearProperties();
        message.setMarshalledProperties(seq);
    }
}

