/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.DataStructureTestSupport;
import org.apache.activemq.command.MessageId;

public class MessageTest
extends DataStructureTestSupport {
    public boolean cacheEnabled;

    public static Test suite() {
        return MessageTest.suite(MessageTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MessageTest.suite());
    }

    public void initCombosForTestActiveMQMessageMarshaling() {
        this.addCombinationValues("cacheEnabled", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testActiveMQMessageMarshaling() throws IOException {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setCommandId(1);
        message.setOriginalDestination((ActiveMQDestination)new ActiveMQQueue("queue"));
        message.setGroupID("group");
        message.setGroupSequence(4);
        message.setCorrelationId("correlation");
        message.setMessageId(new MessageId("c1:1:1", 1L));
        this.assertBeanMarshalls(message);
    }

    public void testActiveMQMessageMarshalingBigMessageId() throws IOException {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setCommandId(1);
        message.setOriginalDestination((ActiveMQDestination)new ActiveMQQueue("queue"));
        message.setGroupID("group");
        message.setGroupSequence(4);
        message.setCorrelationId("correlation");
        message.setMessageId(new MessageId("c1:1:1", 32767L));
        this.assertBeanMarshalls(message);
    }

    public void testActiveMQMessageMarshalingBiggerMessageId() throws IOException {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setCommandId(1);
        message.setOriginalDestination((ActiveMQDestination)new ActiveMQQueue("queue"));
        message.setGroupID("group");
        message.setGroupSequence(4);
        message.setCorrelationId("correlation");
        message.setMessageId(new MessageId("c1:1:1", Integer.MAX_VALUE));
        this.assertBeanMarshalls(message);
    }

    public void testActiveMQMessageMarshalingBiggestMessageId() throws IOException {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setCommandId(1);
        message.setOriginalDestination((ActiveMQDestination)new ActiveMQQueue("queue"));
        message.setGroupID("group");
        message.setGroupSequence(4);
        message.setCorrelationId("correlation");
        message.setMessageId(new MessageId("c1:1:1", Long.MAX_VALUE));
        this.assertBeanMarshalls(message);
    }

    public void testMessageIdMarshaling() throws IOException {
        this.assertBeanMarshalls(new MessageId("c1:1:1", 1L));
    }

    public void testPropRemove() throws Exception {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setStringProperty("RM", "RM");
        ActiveMQMessage unMarshalled = (ActiveMQMessage)this.marshalAndUnmarshall(message, this.wireFormat);
        unMarshalled.getBooleanProperty("NA");
        unMarshalled.removeProperty("RM");
        ActiveMQMessage unMarshalledAgain = (ActiveMQMessage)this.marshalAndUnmarshall(unMarshalled, this.wireFormat);
        MessageTest.assertNull((String)"Prop is gone", (Object)unMarshalledAgain.getProperty("RM"));
    }
}

