/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AMQ6125Test {
    private BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test
    public void testRollbackWithNoPolicy() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(this.broker.getVmConnectorURI());
        cf.setRedeliveryPolicyMap(new RedeliveryPolicyMap());
        Connection connection = cf.createConnection();
        connection.start();
        Session session = connection.createSession(true, 0);
        TemporaryQueue queue = session.createTemporaryQueue();
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send(session.createMessage());
        session.commit();
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message message = consumer.receive(2000L);
        Assert.assertNotNull((Object)message);
        session.rollback();
    }
}

