/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jms.InvalidClientIDException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import junit.framework.TestCase;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.StubBroker;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.security.JaasAuthenticationBroker;
import org.apache.activemq.security.SecurityContext;
import org.apache.activemq.security.StubJaasConfiguration;

public class JaasAuthenticationBrokerTest
extends TestCase {
    StubBroker receiveBroker;
    JaasAuthenticationBroker authBroker;
    ConnectionContext connectionContext;
    ConnectionInfo connectionInfo;
    CopyOnWriteArrayList<SecurityContext> visibleSecurityContexts;

    protected void setUp() throws Exception {
        this.receiveBroker = new StubBroker();
        this.authBroker = new JaasAuthenticationBrokerTester((Broker)this.receiveBroker, "");
        this.connectionContext = new ConnectionContext();
        this.connectionInfo = new ConnectionInfo();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void setConfiguration(boolean loginShouldSucceed) {
        HashMap<String, String> configOptions = new HashMap<String, String>();
        configOptions.put("org.apache.activemq.jaas.stubproperties.allow_login", loginShouldSucceed ? "true" : "false");
        configOptions.put("org.apache.activemq.jaas.stubproperties.users", "");
        configOptions.put("org.apache.activemq.jaas.stubproperties.groups", "");
        AppConfigurationEntry configEntry = new AppConfigurationEntry("org.apache.activemq.security.StubLoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, configOptions);
        StubJaasConfiguration jaasConfig = new StubJaasConfiguration(configEntry);
        Configuration.setConfiguration(jaasConfig);
    }

    public void testAddConnectionFailureOnDuplicateClientId() throws Exception {
        this.setConfiguration(true);
        this.connectionInfo.setClientId("CliIdX");
        this.authBroker.addConnection(this.connectionContext, this.connectionInfo);
        ConnectionContext secondContext = this.connectionContext.copy();
        secondContext.setSecurityContext(null);
        ConnectionInfo secondInfo = this.connectionInfo.copy();
        try {
            this.authBroker.addConnection(secondContext, secondInfo);
            JaasAuthenticationBrokerTest.fail((String)"Expect duplicate id");
        }
        catch (InvalidClientIDException invalidClientIDException) {
            // empty catch block
        }
        JaasAuthenticationBrokerTest.assertEquals((String)"one connection allowed.", (int)1, (int)this.receiveBroker.addConnectionData.size());
        JaasAuthenticationBrokerTest.assertEquals((String)"one context .", (int)1, (int)this.visibleSecurityContexts.size());
    }

    class JaasAuthenticationBrokerTester
    extends JaasAuthenticationBroker {
        public JaasAuthenticationBrokerTester(Broker next, String jassConfiguration) {
            super(next, jassConfiguration);
            JaasAuthenticationBrokerTest.this.visibleSecurityContexts = this.securityContexts;
        }
    }
}

