/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jms.Connection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AMQ6446Test {
    private BrokerService brokerService;
    LinkedList<Connection> connections = new LinkedList();

    @Test
    public void test2Connections() throws Exception {
        String urlTraceParam = "?trace=true";
        this.startBroker("?trace=true");
        final HashSet<String> loggers = new HashSet<String>();
        final HashSet<String> messages = new HashSet<String>();
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                loggers.add(event.getLoggerName());
                messages.add(event.getRenderedMessage());
            }
        };
        Logger.getRootLogger().addAppender((Appender)appender);
        Logger.getRootLogger().setLevel(Level.DEBUG);
        String brokerUrlWithTrace = this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString() + "?trace=true";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerUrlWithTrace);
        for (int i = 0; i < 2; ++i) {
            Connection c = factory.createConnection();
            c.start();
            this.connections.add(c);
        }
        Logger.getRootLogger().removeAppender((Appender)appender);
        Assert.assertFalse((boolean)this.foundMatch(loggers, ".*:2$"));
        Assert.assertTrue((boolean)this.foundMatch(messages, "^0+\\d:.*"));
    }

    public boolean foundMatch(Collection<String> values, String regex) {
        String input;
        Matcher m;
        boolean found = false;
        Pattern p = Pattern.compile(regex);
        Iterator<String> i$ = values.iterator();
        while (i$.hasNext() && !(found = (m = p.matcher(input = i$.next())).matches())) {
        }
        return found;
    }

    @Test
    public void test2ConnectionsLegacy() throws Exception {
        String legacySupportParam = "?trace=true&jmxPort=22";
        this.startBroker("?trace=true&jmxPort=22");
        final HashSet<String> loggers = new HashSet<String>();
        final HashSet<String> messages = new HashSet<String>();
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                loggers.add(event.getLoggerName());
                messages.add(event.getRenderedMessage());
            }
        };
        Logger.getRootLogger().addAppender((Appender)appender);
        Logger.getRootLogger().setLevel(Level.TRACE);
        String brokerUrlWithTrace = this.brokerService.getTransportConnectorByScheme("tcp").getPublishableConnectString() + "?trace=true&jmxPort=22";
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(brokerUrlWithTrace);
        for (int i = 0; i < 2; ++i) {
            Connection c = factory.createConnection();
            c.start();
            this.connections.add(c);
        }
        Logger.getRootLogger().removeAppender((Appender)appender);
        Assert.assertTrue((boolean)this.foundMatch(loggers, ".*:2$"));
        Assert.assertFalse((boolean)this.foundMatch(messages, "^0+\\d:.*"));
    }

    @After
    public void tearDown() throws Exception {
        for (Connection connection : this.connections) {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    public void startBroker(String urlParam) throws Exception {
        this.brokerService = BrokerFactory.createBroker((String)("broker:(tcp://0.0.0.0:0" + urlParam + ")/localhost?useJmx=false&persistent=false"));
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
    }
}

