/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageEOFException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQDestination;

public class JMSMessageTest
extends JmsTestSupport {
    public ActiveMQDestination destination;
    public int deliveryMode = 1;
    public int prefetch;
    public int ackMode;
    public byte destinationType = 1;
    public boolean durableConsumer;
    public String connectURL = "vm://localhost?marshal=false";

    public void initCombos() {
        this.addCombinationValues("connectURL", new Object[]{"vm://localhost?marshal=false", "vm://localhost?marshal=true"});
        this.addCombinationValues("deliveryMode", new Object[]{1, 2});
        this.addCombinationValues("destinationType", new Object[]{(byte)1});
    }

    public void testTextMessage() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        TextMessage message = session.createTextMessage();
        message.setText("Hi");
        producer.send((Message)message);
        message = (TextMessage)consumer.receive(1000L);
        JMSMessageTest.assertNotNull((Object)message);
        JMSMessageTest.assertEquals((String)"Hi", (String)message.getText());
        JMSMessageTest.assertNull((Object)consumer.receiveNoWait());
    }

    public static Test suite() {
        return JMSMessageTest.suite(JMSMessageTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JMSMessageTest.suite());
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws URISyntaxException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(this.connectURL);
        return factory;
    }

    public void testBytesMessageLength() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        BytesMessage message = session.createBytesMessage();
        message.writeInt(1);
        message.writeInt(2);
        message.writeInt(3);
        message.writeInt(4);
        producer.send((Message)message);
        message = (BytesMessage)consumer.receive(1000L);
        JMSMessageTest.assertNotNull((Object)message);
        JMSMessageTest.assertEquals((long)16L, (long)message.getBodyLength());
        JMSMessageTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testObjectMessage() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        ObjectMessage message = session.createObjectMessage();
        message.setObject((Serializable)((Object)"Hi"));
        producer.send((Message)message);
        message = (ObjectMessage)consumer.receive(1000L);
        JMSMessageTest.assertNotNull((Object)message);
        JMSMessageTest.assertEquals((Object)"Hi", (Object)message.getObject());
        JMSMessageTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testBytesMessage() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        BytesMessage message = session.createBytesMessage();
        message.writeBoolean(true);
        producer.send((Message)message);
        message = (BytesMessage)consumer.receive(1000L);
        JMSMessageTest.assertNotNull((Object)message);
        JMSMessageTest.assertTrue((boolean)message.readBoolean());
        try {
            message.readByte();
            JMSMessageTest.fail((String)"Expected exception not thrown.");
        }
        catch (MessageEOFException messageEOFException) {
            // empty catch block
        }
        JMSMessageTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testStreamMessage() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        StreamMessage message = session.createStreamMessage();
        message.writeString("This is a test to see how it works.");
        producer.send((Message)message);
        message = (StreamMessage)consumer.receive(1000L);
        JMSMessageTest.assertNotNull((Object)message);
        try {
            message.readByte();
            JMSMessageTest.fail((String)"Should have received NumberFormatException");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JMSMessageTest.assertEquals((String)"This is a test to see how it works.", (String)message.readString());
        try {
            message.readByte();
            JMSMessageTest.fail((String)"Should have received MessageEOFException");
        }
        catch (MessageEOFException messageEOFException) {
            // empty catch block
        }
        JMSMessageTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testMapMessage() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        MapMessage message = session.createMapMessage();
        message.setBoolean("boolKey", true);
        producer.send((Message)message);
        message = (MapMessage)consumer.receive(1000L);
        JMSMessageTest.assertNotNull((Object)message);
        JMSMessageTest.assertTrue((boolean)message.getBoolean("boolKey"));
        JMSMessageTest.assertNull((Object)consumer.receiveNoWait());
    }

    public void testForeignMessage() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 1);
        this.destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)this.destination);
        MessageProducer producer = session.createProducer((Destination)this.destination);
        ForeignMessage message = new ForeignMessage();
        message.text = "Hello";
        message.setStringProperty("test", "value");
        long timeToLive = 10000L;
        long start = System.currentTimeMillis();
        producer.send((Message)message, this.deliveryMode, 7, timeToLive);
        long end = System.currentTimeMillis();
        JMSMessageTest.assertNotNull((Object)message.getJMSDestination());
        JMSMessageTest.assertEquals((int)this.deliveryMode, (int)message.getJMSDeliveryMode());
        JMSMessageTest.assertTrue((start + timeToLive <= message.getJMSExpiration() ? 1 : 0) != 0);
        JMSMessageTest.assertTrue((end + timeToLive >= message.getJMSExpiration() ? 1 : 0) != 0);
        JMSMessageTest.assertEquals((int)7, (int)message.getJMSPriority());
        JMSMessageTest.assertNotNull((Object)message.getJMSMessageID());
        JMSMessageTest.assertTrue((start <= message.getJMSTimestamp() ? 1 : 0) != 0);
        JMSMessageTest.assertTrue((end >= message.getJMSTimestamp() ? 1 : 0) != 0);
        message = (TextMessage)consumer.receive(1000L);
        JMSMessageTest.assertNotNull((Object)message);
        JMSMessageTest.assertEquals((String)"Hello", (String)message.getText());
        JMSMessageTest.assertEquals((String)"value", (String)message.getStringProperty("test"));
        JMSMessageTest.assertNull((Object)consumer.receiveNoWait());
    }

    static class ForeignMessage
    implements TextMessage {
        public int deliveryMode;
        private String messageId;
        private long timestamp;
        private String correlationId;
        private Destination replyTo;
        private Destination destination;
        private boolean redelivered;
        private String type;
        private long expiration;
        private int priority;
        private String text;
        private final HashMap<String, Object> props = new HashMap();

        ForeignMessage() {
        }

        public String getJMSMessageID() throws JMSException {
            return this.messageId;
        }

        public void setJMSMessageID(String arg0) throws JMSException {
            this.messageId = arg0;
        }

        public long getJMSTimestamp() throws JMSException {
            return this.timestamp;
        }

        public void setJMSTimestamp(long arg0) throws JMSException {
            this.timestamp = arg0;
        }

        public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
            return null;
        }

        public void setJMSCorrelationIDAsBytes(byte[] arg0) throws JMSException {
        }

        public void setJMSCorrelationID(String arg0) throws JMSException {
            this.correlationId = arg0;
        }

        public String getJMSCorrelationID() throws JMSException {
            return this.correlationId;
        }

        public Destination getJMSReplyTo() throws JMSException {
            return this.replyTo;
        }

        public void setJMSReplyTo(Destination arg0) throws JMSException {
            this.replyTo = arg0;
        }

        public Destination getJMSDestination() throws JMSException {
            return this.destination;
        }

        public void setJMSDestination(Destination arg0) throws JMSException {
            this.destination = arg0;
        }

        public int getJMSDeliveryMode() throws JMSException {
            return this.deliveryMode;
        }

        public void setJMSDeliveryMode(int arg0) throws JMSException {
            this.deliveryMode = arg0;
        }

        public boolean getJMSRedelivered() throws JMSException {
            return this.redelivered;
        }

        public void setJMSRedelivered(boolean arg0) throws JMSException {
            this.redelivered = arg0;
        }

        public String getJMSType() throws JMSException {
            return this.type;
        }

        public void setJMSType(String arg0) throws JMSException {
            this.type = arg0;
        }

        public long getJMSExpiration() throws JMSException {
            return this.expiration;
        }

        public void setJMSExpiration(long arg0) throws JMSException {
            this.expiration = arg0;
        }

        public int getJMSPriority() throws JMSException {
            return this.priority;
        }

        public void setJMSPriority(int arg0) throws JMSException {
            this.priority = arg0;
        }

        public void clearProperties() throws JMSException {
        }

        public boolean propertyExists(String arg0) throws JMSException {
            return false;
        }

        public boolean getBooleanProperty(String arg0) throws JMSException {
            return false;
        }

        public byte getByteProperty(String arg0) throws JMSException {
            return 0;
        }

        public short getShortProperty(String arg0) throws JMSException {
            return 0;
        }

        public int getIntProperty(String arg0) throws JMSException {
            return 0;
        }

        public long getLongProperty(String arg0) throws JMSException {
            return 0L;
        }

        public float getFloatProperty(String arg0) throws JMSException {
            return 0.0f;
        }

        public double getDoubleProperty(String arg0) throws JMSException {
            return 0.0;
        }

        public String getStringProperty(String arg0) throws JMSException {
            return (String)this.props.get(arg0);
        }

        public Object getObjectProperty(String arg0) throws JMSException {
            return this.props.get(arg0);
        }

        public Enumeration<?> getPropertyNames() throws JMSException {
            return new Vector<String>(this.props.keySet()).elements();
        }

        public void setBooleanProperty(String arg0, boolean arg1) throws JMSException {
        }

        public void setByteProperty(String arg0, byte arg1) throws JMSException {
        }

        public void setShortProperty(String arg0, short arg1) throws JMSException {
        }

        public void setIntProperty(String arg0, int arg1) throws JMSException {
        }

        public void setLongProperty(String arg0, long arg1) throws JMSException {
        }

        public void setFloatProperty(String arg0, float arg1) throws JMSException {
        }

        public void setDoubleProperty(String arg0, double arg1) throws JMSException {
        }

        public void setStringProperty(String arg0, String arg1) throws JMSException {
            this.props.put(arg0, arg1);
        }

        public void setObjectProperty(String arg0, Object arg1) throws JMSException {
            this.props.put(arg0, arg1);
        }

        public void acknowledge() throws JMSException {
        }

        public void clearBody() throws JMSException {
        }

        public void setText(String arg0) throws JMSException {
            this.text = arg0;
        }

        public String getText() throws JMSException {
            return this.text;
        }
    }
}

