/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQObjectMessage;

public class ActiveMQObjectMessageTest
extends TestCase {
    public ActiveMQObjectMessageTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(ActiveMQObjectMessageTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBytes() throws JMSException, IOException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        String str = "testText";
        msg.setObject((Serializable)((Object)str));
        msg = (ActiveMQObjectMessage)msg.copy();
        ActiveMQObjectMessageTest.assertEquals((Object)msg.getObject(), (Object)str);
    }

    public void testSetObject() throws JMSException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        String str = "testText";
        msg.setObject((Serializable)((Object)str));
        ActiveMQObjectMessageTest.assertTrue((msg.getObject() == str ? 1 : 0) != 0);
    }

    public void testClearBody() throws JMSException {
        ActiveMQObjectMessage objectMessage = new ActiveMQObjectMessage();
        try {
            objectMessage.setObject((Serializable)((Object)"String"));
            objectMessage.clearBody();
            ActiveMQObjectMessageTest.assertFalse((boolean)objectMessage.isReadOnlyBody());
            ActiveMQObjectMessageTest.assertNull((Object)objectMessage.getObject());
            objectMessage.setObject((Serializable)((Object)"String"));
            objectMessage.getObject();
        }
        catch (MessageNotWriteableException mnwe) {
            ActiveMQObjectMessageTest.fail((String)"should be writeable");
        }
    }

    public void testReadOnlyBody() throws JMSException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        msg.setObject((Serializable)((Object)"test"));
        msg.setReadOnlyBody(true);
        try {
            msg.getObject();
        }
        catch (MessageNotReadableException e) {
            ActiveMQObjectMessageTest.fail((String)"should be readable");
        }
        try {
            msg.setObject((Serializable)((Object)"test"));
            ActiveMQObjectMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }

    public void testWriteOnlyBody() throws JMSException {
        ActiveMQObjectMessage msg = new ActiveMQObjectMessage();
        msg.setReadOnlyBody(false);
        try {
            msg.setObject((Serializable)((Object)"test"));
            msg.getObject();
        }
        catch (MessageNotReadableException e) {
            ActiveMQObjectMessageTest.fail((String)"should be readable");
        }
        msg.setReadOnlyBody(true);
        try {
            msg.getObject();
            msg.setObject((Serializable)((Object)"test"));
            ActiveMQObjectMessageTest.fail((String)"should throw exception");
        }
        catch (MessageNotReadableException e) {
            ActiveMQObjectMessageTest.fail((String)"should be readable");
        }
        catch (MessageNotWriteableException messageNotWriteableException) {
            // empty catch block
        }
    }
}

