/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.AssertionFailedError;
import org.apache.activemq.TestSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JmsSendReceiveTestSupport
extends TestSupport
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(JmsSendReceiveTestSupport.class);
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected Session consumeSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected List<Message> messages = this.createConcurrentList();
    protected boolean topic = true;
    protected boolean durable;
    protected int deliveryMode = 2;
    protected final Object lock = new Object();
    protected boolean verbose;
    protected boolean useSeparateSession;
    protected boolean largeMessages;
    protected int largeMessageLoopSize = 4096;

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        String temp = System.getProperty("messageCount");
        if (temp != null && (i = Integer.parseInt(temp)) > 0) {
            this.messageCount = i;
        }
        LOG.info("Message count for test case is: " + this.messageCount);
        this.data = new String[this.messageCount];
        for (i = 0; i < this.messageCount; ++i) {
            this.data[i] = this.createMessageText(i);
        }
    }

    protected String createMessageText(int i) {
        if (this.largeMessages) {
            return this.createMessageBodyText();
        }
        return "Text for message: " + i + " at " + new Date();
    }

    protected String createMessageBodyText() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.largeMessageLoopSize; ++i) {
            buffer.append("0123456789");
        }
        return buffer.toString();
    }

    public void testSendReceive() throws Exception {
        Thread.sleep(1000L);
        this.messages.clear();
        this.sendMessages();
        this.assertMessagesAreReceived();
        LOG.info("" + this.data.length + " messages(s) received, closing down connections");
    }

    protected void sendMessages() throws Exception {
        for (int i = 0; i < this.data.length; ++i) {
            Message message = this.createMessage(i);
            this.configureMessage(message);
            if (this.verbose) {
                LOG.info("About to send a message: " + message + " with text: " + this.data[i]);
            }
            this.sendMessage(i, message);
        }
    }

    protected void sendMessage(int index, Message message) throws Exception {
        this.producer.send(this.producerDestination, message);
    }

    protected Message createMessage(int index) throws JMSException {
        TextMessage message = this.session.createTextMessage(this.data[index]);
        return message;
    }

    protected void configureMessage(Message message) throws JMSException {
    }

    protected void assertMessagesAreReceived() throws JMSException {
        this.waitForMessagesToBeDelivered();
        this.assertMessagesReceivedAreValid(this.messages);
    }

    protected void assertMessagesReceivedAreValid(List<Message> receivedMessages) throws JMSException {
        List<Object> copyOfMessages = Arrays.asList(receivedMessages.toArray());
        int counter = 0;
        if (this.data.length != copyOfMessages.size()) {
            for (Object message : copyOfMessages) {
                LOG.info("<== " + counter++ + " = " + message);
            }
        }
        JmsSendReceiveTestSupport.assertEquals((String)"Invalid number of messages received", (int)this.data.length, (int)receivedMessages.size());
        for (int i = 0; i < this.data.length; ++i) {
            Message received = receivedMessages.get(i);
            try {
                this.assertMessageValid(i, received);
                continue;
            }
            catch (AssertionFailedError e) {
                for (int j = 0; j < this.data.length; ++j) {
                    Message m = receivedMessages.get(j);
                    System.out.println(j + " => " + m.getJMSMessageID());
                }
                throw e;
            }
        }
    }

    protected void assertMessageValid(int index, Message message) throws JMSException {
        TextMessage textMessage = (TextMessage)message;
        String text = textMessage.getText();
        if (this.verbose) {
            LOG.info("Received Text: " + text);
        }
        JmsSendReceiveTestSupport.assertEquals((String)("Message: " + index), (String)this.data[index], (String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessagesToBeDelivered() {
        long maxWaitTime;
        long waitTime = maxWaitTime = 60000L;
        long start = maxWaitTime <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.messages.size() < this.data.length && waitTime >= 0L) {
                try {
                    this.lock.wait(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTime = maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
    }

    public synchronized void onMessage(Message message) {
        this.consumeMessage(message, this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeMessage(Message message, List<Message> messageList) {
        if (this.verbose) {
            LOG.info("Received message: " + message);
        }
        messageList.add(message);
        if (messageList.size() >= this.data.length) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected List<Message> createConcurrentList() {
        return Collections.synchronizedList(new ArrayList());
    }
}

