/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.StreamMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4887Test {
    private static final transient Logger LOG = LoggerFactory.getLogger(AMQ4887Test.class);
    private static final Integer ITERATIONS = 10;
    @Rule
    public TestName name = new TestName();

    @Test
    public void testBytesMessageSetPropertyBeforeCopy() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        this.doTestBytesMessageSetPropertyBeforeCopy((Connection)connection);
    }

    @Test
    public void testBytesMessageSetPropertyBeforeCopyCompressed() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        connectionFactory.setUseCompression(true);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        this.doTestBytesMessageSetPropertyBeforeCopy((Connection)connection);
    }

    public void doTestBytesMessageSetPropertyBeforeCopy(Connection connection) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.toString());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageProducer producer = session.createProducer((Destination)destination);
        BytesMessage message = session.createBytesMessage();
        for (int i = 0; i < ITERATIONS; ++i) {
            long sendTime = System.currentTimeMillis();
            message.setLongProperty("sendTime", sendTime);
            producer.send((Message)message);
            LOG.debug("Receiving message " + i);
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((String)("On message " + i), (Object)receivedMessage);
            Assert.assertTrue((String)("On message " + i), (boolean)(receivedMessage instanceof BytesMessage));
            BytesMessage receivedBytesMessage = (BytesMessage)receivedMessage;
            int numElements = 0;
            try {
                while (true) {
                    receivedBytesMessage.readBoolean();
                    ++numElements;
                }
            }
            catch (Exception exception) {
                LOG.info("Iteration [{}]: Received Message contained {} boolean values.", (Object)i, (Object)numElements);
                Assert.assertEquals((long)i, (long)numElements);
                long receivedSendTime = receivedBytesMessage.getLongProperty("sendTime");
                Assert.assertEquals((String)("On message " + i), (long)receivedSendTime, (long)sendTime);
                message.writeBoolean(true);
                continue;
            }
        }
    }

    @Test
    public void testStreamMessageSetPropertyBeforeCopy() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        this.doTestStreamMessageSetPropertyBeforeCopy((Connection)connection);
    }

    @Test
    public void testStreamMessageSetPropertyBeforeCopyCompressed() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost");
        connectionFactory.setUseCompression(true);
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        this.doTestStreamMessageSetPropertyBeforeCopy((Connection)connection);
    }

    public void doTestStreamMessageSetPropertyBeforeCopy(Connection connection) throws Exception {
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(this.name.toString());
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageProducer producer = session.createProducer((Destination)destination);
        StreamMessage message = session.createStreamMessage();
        for (int i = 0; i < ITERATIONS; ++i) {
            long sendTime = System.currentTimeMillis();
            message.setLongProperty("sendTime", sendTime);
            producer.send((Message)message);
            LOG.debug("Receiving message " + i);
            Message receivedMessage = consumer.receive(5000L);
            Assert.assertNotNull((String)("On message " + i), (Object)receivedMessage);
            Assert.assertTrue((String)("On message " + i), (boolean)(receivedMessage instanceof StreamMessage));
            StreamMessage receivedStreamMessage = (StreamMessage)receivedMessage;
            int numElements = 0;
            try {
                while (true) {
                    receivedStreamMessage.readBoolean();
                    ++numElements;
                }
            }
            catch (Exception exception) {
                LOG.info("Iteration [{}]: Received Message contained {} boolean values.", (Object)i, (Object)numElements);
                Assert.assertEquals((long)i, (long)numElements);
                long receivedSendTime = receivedStreamMessage.getLongProperty("sendTime");
                Assert.assertEquals((String)("On message " + i), (long)receivedSendTime, (long)sendTime);
                message.writeBoolean(true);
                continue;
            }
        }
    }
}

