/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class AMQ5914Test {
    private ActiveMQConnection connection;
    private BrokerService broker;
    private String connectionUri;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setUp() throws Exception {
        this.createBroker();
        this.connection = this.createConnection();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=20000L)
    public void testConsumerReceivePrefetchZeroMessageExpiredInFlight() throws Exception {
        this.connection.start();
        this.connection.getPrefetchPolicy().setAll(0);
        Session session = this.connection.createSession(false, 1);
        Queue queue = session.createQueue(this.name.getMethodName());
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage expiredMessage = session.createTextMessage("expired message");
        TextMessage validMessage = session.createTextMessage("valid message");
        producer.send((Message)expiredMessage, 2, 4, 50L);
        producer.send((Message)validMessage);
        session.close();
        session = this.connection.createSession(true, 0);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message message = consumer.receive(3000L);
        Assert.assertNotNull((Object)message);
        TextMessage received = (TextMessage)message;
        Assert.assertEquals((Object)"expired message", (Object)received.getText());
        session.rollback();
        Thread.sleep(75L);
        message = consumer.receive(3000L);
        Assert.assertNotNull((Object)message);
        received = (TextMessage)message;
        Assert.assertEquals((Object)"valid message", (Object)received.getText());
    }

    private void createBroker() throws Exception {
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry defaultEntry = new PolicyEntry();
        defaultEntry.setExpireMessagesPeriod(60000L);
        defaultEntry.setUseCache(false);
        policyMap.setDefaultEntry(defaultEntry);
        this.broker = new BrokerService();
        this.broker.setUseJmx(false);
        this.broker.setPersistent(false);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        this.broker.waitUntilStarted();
        this.connectionUri = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionUri);
    }

    protected ActiveMQConnection createConnection() throws Exception {
        return (ActiveMQConnection)this.createConnectionFactory().createConnection();
    }
}

