/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.UUID;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6264Test {
    private static final Logger LOG = LoggerFactory.getLogger(AMQ6264Test.class);
    @Rule
    public final TestName testName = new TestName();
    protected final int MESSAGE_COUNT = 2000;
    private final String topicPrefix = "topic.";
    private final String topicFilter = "topic.>";
    private final String topicA = "topic.A";
    private BrokerService broker;
    private Connection connection;
    private String connectionURI;

    @Test(timeout=60000L)
    public void testSlowConsumerAdvisory() throws Exception {
        Session session = this.connection.createSession(false, 1);
        Topic topic = session.createTopic("topic.>");
        TopicSubscriber consumer = session.createDurableSubscriber(topic, this.testName.getMethodName());
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)ActiveMQDestination.createDestination((String)"topic.A", (byte)2));
        session = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = session.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = session.createProducer(null);
        producer.send((Destination)session.createTopic("topic.A"), session.createMessage());
        for (int i = 0; i < 2000; ++i) {
            BytesMessage m = session.createBytesMessage();
            m.writeBytes(new byte[1024]);
            Topic newTopic = session.createTopic("topic." + UUID.randomUUID().toString());
            LOG.debug("Sending message to next topic: {}", (Object)newTopic);
            producer.send((Destination)newTopic, (Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }

    @Before
    public void setUp() throws Exception {
        this.broker = this.createBroker();
        this.connectionURI = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.connection = factory.createConnection();
        this.connection.setClientID(this.getClass().getSimpleName());
        this.connection.start();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connectionURI);
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setPersistent(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setAdvisoryForSlowConsumers(true);
        policy.setProducerFlowControl(false);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        answer.setUseJmx(true);
        answer.setDestinationPolicy(pMap);
        answer.addConnector("tcp://0.0.0.0:0");
        answer.setDeleteAllMessagesOnStartup(true);
        answer.start();
        return answer;
    }
}

