/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jmx;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import junit.framework.TestCase;
import org.apache.activemq.TestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.util.JMXAuditLogEntry;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.activemq.util.TestUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.Test;

public class JmxAuditLogTest
extends TestSupport {
    protected BrokerService broker;
    protected ActiveMQQueue queue;
    int portToUse;

    protected void setUp() throws Exception {
        super.setUp();
        this.setMaxTestTime(TimeUnit.MINUTES.toMillis(10L));
        this.setAutoFail(true);
        System.setProperty("org.apache.activemq.audit", "all");
        this.broker = new BrokerService();
        this.broker.setUseJmx(true);
        this.portToUse = TestUtils.findOpenPort();
        this.broker.setManagementContext(this.createManagementContext("broker", this.portToUse));
        this.broker.setPopulateUserNameInMBeans(true);
        this.broker.setDestinations(this.createDestinations());
        this.broker.start();
    }

    protected void tearDown() throws Exception {
        System.clearProperty("org.apache.activemq.audit");
        this.broker.stop();
        super.tearDown();
    }

    protected ActiveMQDestination[] createDestinations() {
        this.queue = new ActiveMQQueue("myTestQueue");
        return new ActiveMQDestination[]{this.queue};
    }

    private MBeanServerConnection createJMXConnector(int port) throws Exception {
        String url = "service:jmx:rmi:///jndi/rmi://localhost:" + port + "/jmxrmi";
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        String[] creds = new String[]{"admin", "activemq"};
        env.put("jmx.remote.credentials", creds);
        JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(url), env);
        connector.connect();
        return connector.getMBeanServerConnection();
    }

    private ManagementContext createManagementContext(String name, int port) {
        ManagementContext managementContext = new ManagementContext();
        managementContext.setBrokerName(name);
        managementContext.setConnectorPort(port);
        managementContext.setConnectorHost("localhost");
        managementContext.setCreateConnector(true);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("jmx.remote.x.password.file", this.basedir + "/src/test/resources/jmx.password");
        env.put("jmx.remote.x.access.file", this.basedir + "/src/test/resources/jmx.access");
        managementContext.setEnvironment(env);
        return managementContext;
    }

    @Test
    public void testPasswordsAreNotLoggedWhenAuditIsTurnedOn() throws Exception {
        Logger log4jLogger = Logger.getLogger((String)"org.apache.activemq.audit");
        log4jLogger.setLevel(Level.INFO);
        final AtomicInteger logCount = new AtomicInteger(0);
        final AtomicBoolean gotEnded = new AtomicBoolean(false);
        DefaultTestAppender appender = new DefaultTestAppender(){

            public void doAppend(LoggingEvent event) {
                if (event.getMessage() instanceof String) {
                    String message = (String)event.getMessage();
                    System.out.println(message);
                    if (message.contains("testPassword")) {
                        TestCase.fail((String)"Password should not appear in log file");
                    }
                    if (message.contains(JMXAuditLogEntry.VERBS[1])) {
                        gotEnded.set(true);
                    }
                }
                logCount.incrementAndGet();
            }
        };
        log4jLogger.addAppender((Appender)appender);
        MBeanServerConnection conn = this.createJMXConnector(this.portToUse);
        ObjectName queueObjName = new ObjectName(this.broker.getBrokerObjectName() + ",destinationType=Queue,destinationName=" + this.queue.getQueueName());
        Object[] params = new Object[]{"body", "testUser", "testPassword"};
        String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
        conn.invoke(queueObjName, "sendTextMessage", params, signature);
        log4jLogger.removeAppender((Appender)appender);
        JmxAuditLogTest.assertTrue((String)"got ended statement", (boolean)gotEnded.get());
        JmxAuditLogTest.assertEquals((String)"got two messages", (int)2, (int)logCount.get());
    }
}

