/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jndi;

import java.util.Hashtable;
import org.apache.activemq.jndi.ActiveMQWASInitialContextFactory;
import org.apache.activemq.jndi.JNDITestSupport;

public class ActiveMQWASInitialContextFactoryTest
extends JNDITestSupport {
    public void testTransformEnvironment() {
        Hashtable<String, Object> originalEnvironment = new Hashtable<String, Object>();
        originalEnvironment.put("java.naming.connectionFactoryNames", "ConnectionFactory");
        originalEnvironment.put("java.naming.topic.jms.systemMessageTopic", "jms/systemMessageTopic");
        originalEnvironment.put("java.naming.provider.url", "tcp://localhost:61616;tcp://localhost:61617");
        originalEnvironment.put("non-string", 43);
        originalEnvironment.put("java.naming.queue", "jms/systemMessageQueue");
        Hashtable transformedEnvironment = new ActiveMQWASInitialContextFactory().transformEnvironment(originalEnvironment);
        ActiveMQWASInitialContextFactoryTest.assertEquals((String)"ConnectionFactory", (Object)"ConnectionFactory", transformedEnvironment.get("connectionFactoryNames"));
        ActiveMQWASInitialContextFactoryTest.assertEquals((String)"topic.jm", (Object)"jms/systemMessageTopic", transformedEnvironment.get("topic.jms/systemMessageTopic"));
        ActiveMQWASInitialContextFactoryTest.assertEquals((String)"java.naming.provider.url", (Object)"tcp://localhost:61616,tcp://localhost:61617", transformedEnvironment.get("java.naming.provider.url"));
        ActiveMQWASInitialContextFactoryTest.assertNull((String)"non-string", transformedEnvironment.get("non-string"));
        ActiveMQWASInitialContextFactoryTest.assertEquals((String)"queue", (Object)"jms/systemMessageQueue", transformedEnvironment.get("java.naming.queue"));
    }
}

