/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.IOException;
import java.net.URI;
import java.util.Enumeration;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueBrowsingTest {
    private static final Logger LOG = LoggerFactory.getLogger(QueueBrowsingTest.class);
    private BrokerService broker;
    private URI connectUri;
    private ActiveMQConnectionFactory factory;
    private final int maxPageSize = 100;

    @Before
    public void startBroker() throws Exception {
        this.broker = this.createBroker();
        TransportConnector connector = this.broker.addConnector("tcp://0.0.0.0:0");
        this.broker.deleteAllMessages();
        this.broker.start();
        this.broker.waitUntilStarted();
        PolicyEntry policy = new PolicyEntry();
        policy.setMaxPageSize(100);
        this.broker.setDestinationPolicy(new PolicyMap());
        this.broker.getDestinationPolicy().setDefaultEntry(policy);
        this.connectUri = connector.getConnectUri();
        this.factory = new ActiveMQConnectionFactory(this.connectUri);
    }

    public BrokerService createBroker() throws IOException {
        return new BrokerService();
    }

    @After
    public void stopBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void testBrowsing() throws JMSException {
        int i;
        int messageToSend = 370;
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)queue);
        String data = "";
        for (i = 0; i < 2048; ++i) {
            data = data + "x";
        }
        for (i = 0; i < messageToSend; ++i) {
            producer.send((Message)session.createTextMessage(data));
        }
        QueueBrowser browser = session.createBrowser((Queue)queue);
        Enumeration enumeration = browser.getEnumeration();
        int received = 0;
        while (enumeration.hasMoreElements()) {
            Message m = (Message)enumeration.nextElement();
            LOG.info("Browsed message " + ++received + ": " + m.getJMSMessageID());
        }
        browser.close();
        Assert.assertEquals((long)messageToSend, (long)received);
    }

    @Test
    public void testBrowseConcurrent() throws Exception {
        int i;
        int messageToSend = 370;
        final ActiveMQQueue queue = new ActiveMQQueue("TEST");
        Connection connection = this.factory.createConnection();
        connection.start();
        final Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)queue);
        String data = "";
        for (i = 0; i < 2048; ++i) {
            data = data + "x";
        }
        for (i = 0; i < 370; ++i) {
            producer.send((Message)session.createTextMessage(data));
        }
        Thread browserThread = new Thread(){

            @Override
            public void run() {
                try {
                    QueueBrowser browser = session.createBrowser((Queue)queue);
                    Enumeration enumeration = browser.getEnumeration();
                    int received = 0;
                    while (enumeration.hasMoreElements()) {
                        Message m = (Message)enumeration.nextElement();
                        LOG.info("Browsed message " + ++received + ": " + m.getJMSMessageID());
                    }
                    Assert.assertEquals((String)"Browsed all messages", (long)370L, (long)received);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        browserThread.start();
        Thread consumerThread2 = new Thread(){

            @Override
            public void run() {
                try {
                    Message m;
                    MessageConsumer consumer = session.createConsumer((Destination)queue);
                    int received = 0;
                    while ((m = consumer.receive(1000L)) != null) {
                        ++received;
                    }
                    Assert.assertEquals((String)"Consumed all messages", (long)370L, (long)received);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        consumerThread2.start();
        browserThread.join();
        consumerThread2.join();
    }

    @Test
    public void testMemoryLimit() throws Exception {
        int i;
        this.broker.getSystemUsage().getMemoryUsage().setLimit(16384L);
        int messageToSend = 370;
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        Connection connection = this.factory.createConnection();
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = session.createProducer((Destination)queue);
        String data = "";
        for (i = 0; i < 2048; ++i) {
            data = data + "x";
        }
        for (i = 0; i < messageToSend; ++i) {
            producer.send((Message)session.createTextMessage(data));
        }
        QueueBrowser browser = session.createBrowser((Queue)queue);
        Enumeration enumeration = browser.getEnumeration();
        int received = 0;
        while (enumeration.hasMoreElements()) {
            Message m = (Message)enumeration.nextElement();
            LOG.info("Browsed message " + ++received + ": " + m.getJMSMessageID());
        }
        browser.close();
        Assert.assertTrue((String)"got at least maxPageSize", (received >= 100 ? 1 : 0) != 0);
    }
}

