/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.scheduler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.broker.scheduler.Job;
import org.apache.activemq.broker.scheduler.JobScheduler;
import org.apache.activemq.store.kahadb.scheduler.JobSchedulerStoreImpl;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOHelper;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerStoreTest {
    private static final Logger LOG = LoggerFactory.getLogger(JobSchedulerStoreTest.class);

    @Test(timeout=120000L)
    public void testRestart() throws Exception {
        long startTime;
        JobSchedulerStoreImpl store = new JobSchedulerStoreImpl();
        File directory = new File("target/test/ScheduledDB");
        IOHelper.mkdirs((File)directory);
        IOHelper.deleteChildren((File)directory);
        store.setDirectory(directory);
        int NUMBER = 1000;
        store.start();
        ArrayList<ByteSequence> list = new ArrayList<ByteSequence>();
        for (int i = 0; i < 1000; ++i) {
            ByteSequence buff = new ByteSequence(new String("testjob" + i).getBytes());
            list.add(buff);
        }
        JobScheduler js = store.getJobScheduler("test");
        js.startDispatching();
        int count = 0;
        long period = startTime = 600000L;
        for (ByteSequence job : list) {
            js.schedule("id:" + count++, job, "", startTime, period, -1);
        }
        List test = js.getAllJobs();
        LOG.debug("Found {} jobs in the store before restart", (Object)test.size());
        Assert.assertEquals((long)list.size(), (long)test.size());
        store.stop();
        store.start();
        js = store.getJobScheduler("test");
        test = js.getAllJobs();
        LOG.debug("Found {} jobs in the store after restart", (Object)test.size());
        Assert.assertEquals((long)list.size(), (long)test.size());
        for (int i = 0; i < list.size(); ++i) {
            String orig = new String(((ByteSequence)list.get(i)).getData());
            String payload = new String(((Job)test.get(i)).getPayload());
            Assert.assertEquals((Object)orig, (Object)payload);
        }
    }
}

