/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.broker.region.policy.RedeliveryPolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.transport.vm.VMTransportFactory;
import org.apache.activemq.transport.vm.VMTransportServer;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryPolicyTest
extends JmsTestSupport {
    static final Logger LOG = LoggerFactory.getLogger(RedeliveryPolicyTest.class);

    public static Test suite() {
        return RedeliveryPolicyTest.suite(RedeliveryPolicyTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RedeliveryPolicyTest.suite());
    }

    public void testGetNext() throws Exception {
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        long delay = policy.getNextRedeliveryDelay(0L);
        RedeliveryPolicyTest.assertEquals((long)500L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)1000L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)2000L, (long)delay);
        policy.setUseExponentialBackOff(false);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)500L, (long)delay);
    }

    public void testGetNextWithInitialDelay() throws Exception {
        RedeliveryPolicy policy = new RedeliveryPolicy();
        policy.setInitialRedeliveryDelay(500L);
        long delay = policy.getNextRedeliveryDelay(500L);
        RedeliveryPolicyTest.assertEquals((long)1000L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)1000L, (long)delay);
        delay = policy.getNextRedeliveryDelay(delay);
        RedeliveryPolicyTest.assertEquals((long)1000L, (long)delay);
    }

    public void testExponentialRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue(this.getName());
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(500L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
    }

    public void testNornalRedeliveryPolicyDelaysDeliveryOnRollback() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(500L);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue(this.getName());
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(700L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
    }

    public void testDLQHandling() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        MessageConsumer dlqConsumer = session.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
        m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        String cause = m.getStringProperty("dlqDeliveryFailureCause");
        RedeliveryPolicyTest.assertTrue((String)("cause exception has policy ref: " + cause), (boolean)cause.contains("RedeliveryPolicy"));
        RedeliveryPolicyTest.assertTrue((String)("cause exception has redelivered count ref: " + cause), (boolean)cause.contains("[3]"));
        session.commit();
    }

    public void testInfiniteMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(-1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testMaximumRedeliveryDelay() throws Exception {
        TextMessage m;
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(10L);
        policy.setUseExponentialBackOff(true);
        policy.setMaximumRedeliveries(-1);
        policy.setRedeliveryDelay(50L);
        policy.setMaximumRedeliveryDelay(1000L);
        policy.setBackOffMultiplier(2.0);
        policy.setUseExponentialBackOff(true);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        for (int i = 0; i < 10; ++i) {
            m = (TextMessage)consumer.receive(2000L);
            RedeliveryPolicyTest.assertNotNull((Object)m);
            RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
            session.rollback();
        }
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.commit();
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
        RedeliveryPolicyTest.assertTrue((policy.getNextRedeliveryDelay(Long.MAX_VALUE) == 1000L ? 1 : 0) != 0);
    }

    public void testZeroMaximumNumberOfRedeliveries() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(100L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(0);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testRepeatedRedeliveryReceiveNoCommit() throws Exception {
        this.connection.start();
        Session dlqSession = this.connection.createSession(true, 0);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = dlqSession.createProducer((Destination)destination);
        producer.send((Message)dlqSession.createTextMessage("1st"));
        dlqSession.commit();
        MessageConsumer dlqConsumer = dlqSession.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        int maxRedeliveries = 4;
        for (int i = 0; i <= 5; ++i) {
            this.connection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
            this.connections.add(this.connection);
            RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
            policy.setInitialRedeliveryDelay(0L);
            policy.setUseExponentialBackOff(false);
            policy.setMaximumRedeliveries(4);
            this.connection.start();
            Session session = this.connection.createSession(true, 1);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            ActiveMQTextMessage m = (ActiveMQTextMessage)consumer.receive(4000L);
            if (i <= 4) {
                RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
                RedeliveryPolicyTest.assertEquals((int)i, (int)m.getRedeliveryCounter());
            } else {
                RedeliveryPolicyTest.assertNull((String)"null on exceeding redelivery count", (Object)m);
            }
            this.connection.close();
            this.connections.remove(this.connection);
        }
        TextMessage m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((String)"Got message from DLQ", (Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        String cause = m.getStringProperty("dlqDeliveryFailureCause");
        RedeliveryPolicyTest.assertTrue((String)("cause exception has policy ref: " + cause), (boolean)cause.contains("RedeliveryPolicy"));
        RedeliveryPolicyTest.assertTrue((String)("cause exception has pre dispatch and count:" + cause), (boolean)cause.contains("Delivery[5]"));
        dlqSession.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRepeatedRedeliveryBrokerCloseReceiveNoCommit() throws Exception {
        this.connection.start();
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        Session session = this.connection.createSession(true, 0);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        session.commit();
        int maxRedeliveries = 4;
        for (int i = 0; i <= 5; ++i) {
            final ActiveMQConnection consumerConnection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
            this.connections.add(consumerConnection);
            RedeliveryPolicy policy = consumerConnection.getRedeliveryPolicy();
            policy.setInitialRedeliveryDelay(0L);
            policy.setUseExponentialBackOff(false);
            policy.setMaximumRedeliveries(4);
            consumerConnection.start();
            session = consumerConnection.createSession(true, 1);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            ActiveMQTextMessage m = (ActiveMQTextMessage)consumer.receive(4000L);
            if (i <= 4) {
                RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
                RedeliveryPolicyTest.assertEquals((int)i, (int)m.getRedeliveryCounter());
            } else {
                RedeliveryPolicyTest.assertNull((String)"null on exceeding redelivery count", (Object)m);
                RedeliveryPolicyTest.assertTrue((String)"message in dlq", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                    public boolean isSatisified() throws Exception {
                        LOG.info("total dequeue count: " + RedeliveryPolicyTest.this.broker.getAdminView().getTotalDequeueCount());
                        return RedeliveryPolicyTest.this.broker.getAdminView().getTotalDequeueCount() == 1L;
                    }
                }));
            }
            for (VMTransportServer transportServer : VMTransportFactory.SERVERS.values()) {
                transportServer.stop();
            }
            Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return consumerConnection.isTransportFailed();
                }
            });
            try {
                consumerConnection.close();
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                this.connections.remove(consumerConnection);
            }
        }
        this.connection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
        this.connection.start();
        this.connections.add(this.connection);
        Session dlqSession = this.connection.createSession(true, 0);
        MessageConsumer dlqConsumer = dlqSession.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        TextMessage m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((String)"Got message from DLQ", (Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        String cause = m.getStringProperty("dlqDeliveryFailureCause");
        RedeliveryPolicyTest.assertTrue((String)("cause exception has policy ref: " + cause), (boolean)cause.contains("RedeliveryPolicy"));
        RedeliveryPolicyTest.assertTrue((String)("cause exception has pre dispatch and count:" + cause), (boolean)cause.contains("Dispatch[5]"));
        dlqSession.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRepeatedRedeliveryReceiveBrokerCloseNoPreDispatchCheck() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        session.commit();
        int maxRedeliveries = 4;
        for (int i = 0; i <= 5; ++i) {
            final ActiveMQConnection consumerConnection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
            this.connections.add(consumerConnection);
            RedeliveryPolicy policy = consumerConnection.getRedeliveryPolicy();
            policy.setInitialRedeliveryDelay(0L);
            policy.setUseExponentialBackOff(false);
            policy.setMaximumRedeliveries(4);
            policy.setPreDispatchCheck(false);
            consumerConnection.start();
            session = consumerConnection.createSession(true, 1);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            ActiveMQTextMessage m = (ActiveMQTextMessage)consumer.receive(4000L);
            RedeliveryPolicyTest.assertNotNull((String)("got message on i=" + i), (Object)m);
            RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
            RedeliveryPolicyTest.assertEquals((int)i, (int)m.getRedeliveryCounter());
            for (VMTransportServer transportServer : VMTransportFactory.SERVERS.values()) {
                transportServer.stop();
            }
            Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    return consumerConnection.isTransportFailed();
                }
            });
            try {
                consumerConnection.close();
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            finally {
                this.connections.remove(consumerConnection);
            }
        }
    }

    public void testRepeatedRedeliveryOnMessageNoCommit() throws Exception {
        this.connection.start();
        Session dlqSession = this.connection.createSession(true, 0);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = dlqSession.createProducer((Destination)destination);
        producer.send((Message)dlqSession.createTextMessage("1st"));
        dlqSession.commit();
        MessageConsumer dlqConsumer = dlqSession.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        int maxRedeliveries = 4;
        final AtomicInteger receivedCount = new AtomicInteger(0);
        for (int i = 0; i <= 5; ++i) {
            this.connection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
            this.connections.add(this.connection);
            RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
            policy.setInitialRedeliveryDelay(0L);
            policy.setUseExponentialBackOff(false);
            policy.setMaximumRedeliveries(4);
            this.connection.start();
            Session session = this.connection.createSession(true, 0);
            MessageConsumer consumer = session.createConsumer((Destination)destination);
            final CountDownLatch done = new CountDownLatch(1);
            consumer.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        ActiveMQTextMessage m = (ActiveMQTextMessage)message;
                        TestCase.assertEquals((String)"1st", (String)m.getText());
                        TestCase.assertEquals((int)receivedCount.get(), (int)m.getRedeliveryCounter());
                        receivedCount.incrementAndGet();
                        done.countDown();
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                }
            });
            if (i <= 4) {
                RedeliveryPolicyTest.assertTrue((String)"listener done", (boolean)done.await(5L, TimeUnit.SECONDS));
            } else {
                RedeliveryPolicyTest.assertFalse((String)"listener done", (boolean)done.await(1L, TimeUnit.SECONDS));
            }
            this.connection.close();
            this.connections.remove(this.connection);
        }
        TextMessage m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((String)"Got message from DLQ", (Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        String cause = m.getStringProperty("dlqDeliveryFailureCause");
        LOG.info("cause: " + cause);
        RedeliveryPolicyTest.assertTrue((String)"cause exception has policy ref", (boolean)cause.contains("RedeliveryPolicy"));
        RedeliveryPolicyTest.assertTrue((String)("cause exception has redelivered count ref: " + cause), (boolean)cause.contains("[5]"));
        dlqSession.commit();
    }

    public void testRepeatedRedeliveryServerSessionNoCommit() throws Exception {
        this.connection.start();
        Session dlqSession = this.connection.createSession(true, 0);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = dlqSession.createProducer((Destination)destination);
        producer.send((Message)dlqSession.createTextMessage("1st"));
        dlqSession.commit();
        MessageConsumer dlqConsumer = dlqSession.createConsumer((Destination)new ActiveMQQueue("ActiveMQ.DLQ"));
        int maxRedeliveries = 4;
        final AtomicInteger receivedCount = new AtomicInteger(0);
        for (int i = 0; i <= 5; ++i) {
            this.connection = (ActiveMQConnection)this.factory.createConnection(this.userName, this.password);
            this.connections.add(this.connection);
            RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
            policy.setInitialRedeliveryDelay(0L);
            policy.setUseExponentialBackOff(false);
            policy.setMaximumRedeliveries(4);
            this.connection.start();
            final CountDownLatch done = new CountDownLatch(1);
            final ActiveMQSession session = (ActiveMQSession)this.connection.createSession(true, 0);
            session.setMessageListener(new MessageListener(){

                public void onMessage(Message message) {
                    try {
                        ActiveMQTextMessage m = (ActiveMQTextMessage)message;
                        LOG.info("Got: " + ((ActiveMQTextMessage)message).getMessageId() + ", seq:" + ((ActiveMQTextMessage)message).getMessageId().getBrokerSequenceId());
                        TestCase.assertEquals((String)"1st", (String)m.getText());
                        TestCase.assertEquals((int)receivedCount.get(), (int)m.getRedeliveryCounter());
                        receivedCount.incrementAndGet();
                        done.countDown();
                    }
                    catch (Exception ignored) {
                        ignored.printStackTrace();
                    }
                }
            });
            this.connection.createConnectionConsumer((Destination)destination, null, new ServerSessionPool(){

                public ServerSession getServerSession() throws JMSException {
                    return new ServerSession(){

                        public Session getSession() throws JMSException {
                            return session;
                        }

                        public void start() throws JMSException {
                        }
                    };
                }
            }, 100, false);
            Wait.waitFor((Wait.Condition)new Wait.Condition(){

                public boolean isSatisified() throws Exception {
                    session.run();
                    return done.await(10L, TimeUnit.MILLISECONDS);
                }
            }, (long)5000L);
            if (i <= 4) {
                RedeliveryPolicyTest.assertTrue((String)("listener done @" + i), (boolean)done.await(5L, TimeUnit.SECONDS));
            } else {
                RedeliveryPolicyTest.assertFalse((String)("listener not done @" + i), (boolean)done.await(1L, TimeUnit.SECONDS));
            }
            this.connection.close();
            this.connections.remove(this.connection);
        }
        TextMessage m = (TextMessage)dlqConsumer.receive(1000L);
        RedeliveryPolicyTest.assertNotNull((String)"Got message from DLQ", (Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        String cause = m.getStringProperty("dlqDeliveryFailureCause");
        RedeliveryPolicyTest.assertTrue((String)"cause exception has policy ref", (boolean)cause.contains("RedeliveryPolicy"));
        dlqSession.commit();
    }

    public void testInitialRedeliveryDelayZero() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
        session.commit();
    }

    public void testInitialRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(1);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testRedeliveryDelayOne() throws Exception {
        RedeliveryPolicy policy = this.connection.getRedeliveryPolicy();
        policy.setInitialRedeliveryDelay(0L);
        policy.setRedeliveryDelay(1000L);
        policy.setUseExponentialBackOff(false);
        policy.setMaximumRedeliveries(2);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        MessageProducer producer = session.createProducer((Destination)destination);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        producer.send((Message)session.createTextMessage("1st"));
        producer.send((Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        session.rollback();
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)consumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)consumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }

    public void testRedeliveryPolicyPerDestination() throws Exception {
        RedeliveryPolicy queuePolicy = new RedeliveryPolicy();
        queuePolicy.setInitialRedeliveryDelay(0L);
        queuePolicy.setRedeliveryDelay(1000L);
        queuePolicy.setUseExponentialBackOff(false);
        queuePolicy.setMaximumRedeliveries(2);
        RedeliveryPolicy topicPolicy = new RedeliveryPolicy();
        topicPolicy.setInitialRedeliveryDelay(0L);
        topicPolicy.setRedeliveryDelay(1000L);
        topicPolicy.setUseExponentialBackOff(false);
        topicPolicy.setMaximumRedeliveries(3);
        RedeliveryPolicyMap map = this.connection.getRedeliveryPolicyMap();
        map.put((ActiveMQDestination)new ActiveMQTopic(">"), (Object)topicPolicy);
        map.put((ActiveMQDestination)new ActiveMQQueue(">"), (Object)queuePolicy);
        this.connection.start();
        Session session = this.connection.createSession(true, 1);
        ActiveMQQueue queue = new ActiveMQQueue("TEST");
        ActiveMQTopic topic = new ActiveMQTopic("TEST");
        MessageProducer producer = session.createProducer(null);
        MessageConsumer queueConsumer = session.createConsumer((Destination)queue);
        MessageConsumer topicConsumer = session.createConsumer((Destination)topic);
        producer.send((Destination)queue, (Message)session.createTextMessage("1st"));
        producer.send((Destination)queue, (Message)session.createTextMessage("2nd"));
        producer.send((Destination)topic, (Message)session.createTextMessage("1st"));
        producer.send((Destination)topic, (Message)session.createTextMessage("2nd"));
        session.commit();
        TextMessage m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((String)"first immediate redelivery", (Object)m);
        session.rollback();
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((String)("second delivery delayed: " + m), (Object)m);
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.rollback();
        m = (TextMessage)queueConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(2000L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"1st", (String)m.getText());
        m = (TextMessage)queueConsumer.receive(100L);
        RedeliveryPolicyTest.assertNull((Object)m);
        m = (TextMessage)topicConsumer.receive(100L);
        RedeliveryPolicyTest.assertNotNull((Object)m);
        RedeliveryPolicyTest.assertEquals((String)"2nd", (String)m.getText());
        session.commit();
    }
}

