/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.Arrays;
import java.util.Collection;
import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.policy.AbortSlowConsumer1Test;
import org.apache.activemq.broker.region.policy.AbortSlowAckConsumerStrategy;
import org.apache.activemq.broker.region.policy.AbortSlowConsumerStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SlowConsumerStrategy;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AbortSlowAckConsumer1Test
extends AbortSlowConsumer1Test {
    protected long maxTimeSinceLastAck = 5000L;

    @Parameterized.Parameters(name="abortConnection({0})-isTopic({1})")
    public static Collection<Object[]> getTestParameters() {
        return Arrays.asList({Boolean.TRUE, Boolean.TRUE}, {Boolean.FALSE, Boolean.TRUE}, {Boolean.TRUE, Boolean.FALSE}, {Boolean.FALSE, Boolean.FALSE});
    }

    public AbortSlowAckConsumer1Test(Boolean abortConnection, Boolean topic) {
        super(abortConnection, topic);
    }

    @Override
    protected AbortSlowConsumerStrategy createSlowConsumerStrategy() {
        return new AbortSlowConsumerStrategy();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        AbortSlowAckConsumerStrategy strategy = new AbortSlowAckConsumerStrategy();
        strategy.setAbortConnection(this.abortConnection);
        strategy.setCheckPeriod(this.checkPeriod);
        strategy.setMaxSlowDuration(this.maxSlowDuration);
        strategy.setMaxTimeSinceLastAck(this.maxTimeSinceLastAck);
        policy.setSlowConsumerStrategy((SlowConsumerStrategy)strategy);
        policy.setQueuePrefetch(10);
        policy.setTopicPrefetch(10);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    @Override
    protected ConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("vm://localhost");
        factory.getPrefetchPolicy().setAll(1);
        return factory;
    }
}

