/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import java.net.URI;
import java.util.Collections;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.DestinationInterceptor;
import org.apache.activemq.broker.region.virtual.CompositeQueue;
import org.apache.activemq.broker.region.virtual.VirtualDestination;
import org.apache.activemq.broker.region.virtual.VirtualDestinationInterceptor;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultipleCompositeToPhysicalQueueTest {
    private final ActiveMQQueue SUB1 = new ActiveMQQueue("SUB1");
    private final CompositeQueue PUB_BROADCAST = this.newCompositeQueue("PUB.ALL", (ActiveMQDestination)this.SUB1);
    private final CompositeQueue PUB_INDIVIDUAL = this.newCompositeQueue("PUB.SUB1", (ActiveMQDestination)this.SUB1);
    private String url;
    private BrokerService broker;

    @Before
    public void before() throws Exception {
        this.broker = this.createBroker(false);
        VirtualDestinationInterceptor virtualDestinationInterceptor = new VirtualDestinationInterceptor();
        virtualDestinationInterceptor.setVirtualDestinations(new VirtualDestination[]{this.PUB_BROADCAST, this.PUB_INDIVIDUAL});
        this.broker.setDestinationInterceptors(new DestinationInterceptor[]{virtualDestinationInterceptor});
        this.broker.start();
        this.broker.waitUntilStarted();
        this.url = this.broker.getConnectorByName("tcp").getConnectUri().toString();
    }

    @After
    public void after() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test(timeout=60000L)
    public void testManyToOne() throws Exception {
        Session consumerSession = this.buildSession("Consumer", this.url);
        MessageConsumer consumer = this.createSubscriber(consumerSession, (Destination)this.SUB1, null);
        Session publisherSession = this.buildSession("Producer", this.url);
        this.createPublisher(publisherSession, (Destination)this.PUB_BROADCAST.getVirtualDestination()).send((Message)publisherSession.createTextMessage("BROADCAST"));
        Assert.assertEquals((Object)"BROADCAST", (Object)((TextMessage)consumer.receive()).getText());
        this.createPublisher(publisherSession, (Destination)this.PUB_INDIVIDUAL.getVirtualDestination()).send((Message)publisherSession.createTextMessage("INDIVIDUAL"));
        Assert.assertEquals((Object)"INDIVIDUAL", (Object)((TextMessage)consumer.receive()).getText());
    }

    private BrokerService createBroker(boolean persistent) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("TestBroker");
        broker.setPersistent(persistent);
        TransportConnector connector = new TransportConnector();
        connector.setUri(new URI("tcp://localhost:0"));
        connector.setName("tcp");
        broker.addConnector(connector);
        return broker;
    }

    private MessageConsumer createSubscriber(Session session, Destination destination, MessageListener messageListener) throws JMSException {
        MessageConsumer consumer = session.createConsumer(destination);
        consumer.setMessageListener(messageListener);
        return consumer;
    }

    private MessageProducer createPublisher(Session session, Destination destination) throws JMSException {
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(1);
        return producer;
    }

    private Session buildSession(String clientId, String url) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(url);
        connectionFactory.setClientIDPrefix(clientId);
        Connection connection = connectionFactory.createConnection();
        Session session = connection.createSession(false, 1);
        connection.start();
        return session;
    }

    private CompositeQueue newCompositeQueue(String name, ActiveMQDestination forwardTo) {
        CompositeQueue queue = new CompositeQueue();
        queue.setName(name);
        queue.setForwardTo(Collections.singleton(forwardTo));
        return queue;
    }
}

