/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.security.AuthenticationUser;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.DefaultAuthorizationMap;
import org.apache.activemq.security.SimpleAuthenticationPlugin;
import org.apache.activemq.transport.InactivityIOException;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.apache.activemq.util.Wait;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TlsSessionResumeFailoverReconnectTest {
    private BrokerService brokerService;
    private String sslUrl;
    private String nioSslUrl;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";
    public static final String TRUST_KEYSTORE = "src/test/resources/org/apache/activemq/security/broker1.ks";

    @BeforeClass
    public static void before() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", "src/test/resources/org/apache/activemq/security/broker1.ks");
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
    }

    public BrokerPlugin configureAuthentication() throws Exception {
        ArrayList<AuthenticationUser> users = new ArrayList<AuthenticationUser>();
        users.add(new AuthenticationUser("publisher", "123", "publisher"));
        users.add(new AuthenticationUser("subscriber", "123", "subscriber"));
        users.add(new AuthenticationUser("admin", "123", "publisher,subscriber"));
        users.add(new AuthenticationUser("noConnAdvisoryPerm", "123", "noConnAdvisoryPermGroup"));
        SimpleAuthenticationPlugin authenticationPlugin = new SimpleAuthenticationPlugin(users);
        return authenticationPlugin;
    }

    public BrokerPlugin configureAuthorization() throws Exception {
        ArrayList<AuthorizationEntry> authorizationEntries = new ArrayList<AuthorizationEntry>();
        AuthorizationEntry entry = new AuthorizationEntry();
        entry.setTopic("dcu.>");
        entry.setRead("subscriber");
        entry.setWrite("publisher");
        entry.setAdmin("publisher,subscriber");
        authorizationEntries.add(entry);
        entry = new AuthorizationEntry();
        entry.setTopic("ActiveMQ.Advisory.>");
        entry.setRead("publisher,subscriber");
        entry.setWrite("publisher,subscriber,noConnAdvisoryPermGroup");
        entry.setAdmin("publisher,subscriber,noConnAdvisoryPermGroup");
        authorizationEntries.add(entry);
        entry = new AuthorizationEntry();
        entry.setTopic("ActiveMQ.Advisory.Connection.>");
        entry.setRead("noConnAdvisoryPermGroup,publisher,subscriber");
        entry.setWrite("noConnAdvisoryPermGroup,publisher,subscriber");
        entry.setAdmin("noConnAdvisoryPermGroup,publisher,subscriber");
        authorizationEntries.add(entry);
        entry = new AuthorizationEntry();
        entry.setQueue("Q.*");
        entry.setRead("noConnAdvisoryPermGroup");
        entry.setWrite("noConnAdvisoryPermGroup");
        entry.setAdmin("noConnAdvisoryPermGroup");
        authorizationEntries.add(entry);
        DefaultAuthorizationMap authorizationMap = new DefaultAuthorizationMap(authorizationEntries);
        AuthorizationPlugin authorizationPlugin = new AuthorizationPlugin((AuthorizationMap)authorizationMap);
        return authorizationPlugin;
    }

    @Before
    public void setup() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        TransportConnector transportConnectorSsl = new TransportConnector();
        transportConnectorSsl.setUri(new URI("ssl://localhost:0?transport.useInactivityMonitor=false"));
        transportConnectorSsl.setName("ssl");
        TransportConnector transportConnectorNioSsl = new TransportConnector();
        transportConnectorNioSsl.setUri(new URI("nio+ssl://localhost:0?transport.useInactivityMonitor=false"));
        transportConnectorNioSsl.setName("nio+ssl");
        this.brokerService.addConnector(transportConnectorSsl);
        this.brokerService.addConnector(transportConnectorNioSsl);
        ArrayList<BrokerPlugin> plugins = new ArrayList<BrokerPlugin>();
        plugins.add(this.configureAuthentication());
        plugins.add(this.configureAuthorization());
        BrokerPlugin[] array = new BrokerPlugin[plugins.size()];
        this.brokerService.setPlugins(plugins.toArray(array));
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        this.sslUrl = transportConnectorSsl.getPublishableConnectString();
        this.nioSslUrl = transportConnectorNioSsl.getPublishableConnectString();
    }

    @After
    public void shutdown() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
            this.brokerService = null;
        }
    }

    @Test(timeout=3000000L)
    public void testFailoverReconnectAuthTLSResumeNio() throws Exception {
        this.doTestReconnect(true);
    }

    @Test(timeout=3000000L)
    public void testFailoverReconnectAuthTLSResume() throws Exception {
        this.doTestReconnect(false);
    }

    public void doTestReconnect(final boolean useNio) throws Exception {
        URI uri = new URI(useNio ? this.nioSslUrl : this.sslUrl);
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:(ssl://localhost:" + uri.getPort() + "?wireFormat.maxInactivityDuration=1)");
        factory.setWatchTopicAdvisories(false);
        int numConnections = 60;
        for (int repeats = 0; repeats < 1; ++repeats) {
            ArrayList<ActiveMQConnection> connections = new ArrayList<ActiveMQConnection>(60);
            for (int i = 0; i < 60; ++i) {
                ActiveMQConnection connection1 = (ActiveMQConnection)factory.createConnection("noConnAdvisoryPerm", "123");
                connection1.setClientID("CID" + i);
                connection1.start();
                for (int j = 0; j < 1; ++j) {
                    Session session1 = connection1.createSession(false, 1);
                    Queue queue = session1.createQueue("Q." + j);
                    for (int k = 0; k < 1; ++k) {
                        MessageConsumer messageConsumer = session1.createConsumer((Destination)queue);
                    }
                }
                connections.add(connection1);
            }
            final CountDownLatch caught = new CountDownLatch(60);
            final CountDownLatch resumed = new CountDownLatch(60);
            for (ActiveMQConnection c : connections) {
                final FailoverTransport failoverTransport = (FailoverTransport)c.getTransport().narrow(FailoverTransport.class);
                final TransportListener delegate = failoverTransport.getTransportListener();
                failoverTransport.setTransportListener(new TransportListener(){

                    public void onCommand(Object command) {
                        delegate.onCommand(command);
                    }

                    public void onException(IOException error) {
                        delegate.onException(error);
                    }

                    public void transportInterupted() {
                        caught.countDown();
                        delegate.transportInterupted();
                    }

                    public void transportResumed() {
                        resumed.countDown();
                        delegate.transportResumed();
                    }
                });
                Assert.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

                    public boolean isSatisified() throws Exception {
                        return failoverTransport.isConnected();
                    }
                }));
            }
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    for (TransportConnection transportConnection : TlsSessionResumeFailoverReconnectTest.this.brokerService.getTransportConnectorByName(useNio ? "nio+ssl" : "ssl").getConnections()) {
                        transportConnection.serviceException((Throwable)new InactivityIOException("BOOM"));
                    }
                }
            });
            Assert.assertTrue((boolean)caught.await(10L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)resumed.await(20L, TimeUnit.SECONDS));
            for (ActiveMQConnection c : connections) {
                FailoverTransport failoverTransport = (FailoverTransport)c.getTransport().narrow(FailoverTransport.class);
                Assert.assertTrue((String)("Connected ok: " + c), (boolean)failoverTransport.isConnected());
            }
            for (ActiveMQConnection c : connections) {
                c.close();
            }
        }
    }
}

