/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchedMessagePriorityConsumerTest
extends JmsTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(BatchedMessagePriorityConsumerTest.class);

    public void testBatchWithLowPriorityFirstAndClientSupport() throws Exception {
        this.doTestBatchWithLowPriorityFirst(true);
    }

    public void testBatchWithLowPriorityFirstAndClientSupportOff() throws Exception {
        this.doTestBatchWithLowPriorityFirst(false);
    }

    public void doTestBatchWithLowPriorityFirst(boolean clientPrioritySupport) throws Exception {
        this.connection.start();
        this.connection.setMessagePrioritySupported(clientPrioritySupport);
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        MessageProducer producer = session.createProducer((Destination)destination);
        producer.setPriority(0);
        this.sendMessages(session, producer, 2);
        producer.close();
        MessageProducer producer2 = session.createProducer((Destination)destination);
        producer2.setPriority(9);
        this.sendMessages(session, producer2, 3);
        producer2.close();
        session.close();
        Session consumerSession = this.connection.createSession(true, 0);
        MessageConsumer messageConsumer = consumerSession.createConsumer((Destination)destination);
        for (int i = 0; i < 5; ++i) {
            Message message = messageConsumer.receive(4000L);
            LOG.info("MessageID: " + message.getJMSMessageID());
        }
        consumerSession.commit();
        consumerSession.close();
        consumerSession = this.connection.createSession(false, 1);
        messageConsumer = consumerSession.createConsumer((Destination)destination);
        BatchedMessagePriorityConsumerTest.assertNull((String)"No message left", (Object)messageConsumer.receive(1000L));
        consumerSession.close();
    }
}

