/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.advisory;

import java.util.HashSet;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.ConstantPendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AdvisoryTests {
    protected static final int MESSAGE_COUNT = 2000;
    protected BrokerService broker;
    protected Connection connection;
    protected String bindAddress = ActiveMQConnectionFactory.DEFAULT_BROKER_BIND_URL;
    protected int topicCount;
    protected final int EXPIRE_MESSAGE_PERIOD = 10000;

    @Test(timeout=60000L)
    public void testNoSlowConsumerAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
            }
        });
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        s = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        for (int i = 0; i < 2000; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testSlowConsumerAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getSlowConsumerAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        s = this.connection.createSession(false, 1);
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        for (int i = 0; i < 2000; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testMessageDeliveryAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getMessageDeliveredAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        Assert.assertEquals((Object)message.getProperty("orignalDestination"), (Object)((ActiveMQDestination)queue).getQualifiedName());
    }

    @Test(timeout=60000L)
    public void testMessageConsumedAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getMessageConsumedAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        String id = m.getJMSMessageID();
        Message msg = consumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        ActiveMQMessage payload = (ActiveMQMessage)message.getDataStructure();
        String originalId = payload.getJMSMessageID();
        Assert.assertEquals((Object)originalId, (Object)id);
        Assert.assertEquals((Object)message.getProperty("orignalDestination"), (Object)((ActiveMQDestination)queue).getQualifiedName());
    }

    @Test(timeout=60000L)
    public void testMessageExpiredAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        Queue queue = s.createQueue(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)queue);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getExpiredMessageTopic((ActiveMQDestination)((ActiveMQDestination)queue));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)queue);
        producer.setTimeToLive(1L);
        for (int i = 0; i < 2000; ++i) {
            BytesMessage m = s.createBytesMessage();
            m.writeBytes(new byte[1024]);
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(10000L);
        Assert.assertNotNull((Object)msg);
    }

    @Test(timeout=60000L)
    public void testMessageDLQd() throws Exception {
        ActiveMQPrefetchPolicy policy = new ActiveMQPrefetchPolicy();
        policy.setTopicPrefetch(2);
        ((ActiveMQConnection)this.connection).setPrefetchPolicy(policy);
        Session s = this.connection.createSession(false, 2);
        Topic topic = s.createTopic(this.getClass().getName());
        Topic advisoryTopic = s.createTopic(">");
        for (int i = 0; i < 100; ++i) {
            s.createConsumer((Destination)advisoryTopic);
        }
        MessageProducer producer = s.createProducer((Destination)topic);
        int count = 10;
        for (int i = 0; i < count; ++i) {
            BytesMessage m = s.createBytesMessage();
            producer.send((Message)m);
        }
    }

    @Test(timeout=60000L)
    public void testMessageDiscardedAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 2);
        Topic topic = s.createTopic(this.getClass().getName());
        MessageConsumer consumer = s.createConsumer((Destination)topic);
        Assert.assertNotNull((Object)consumer);
        ActiveMQTopic advisoryTopic = AdvisorySupport.getMessageDiscardedAdvisoryTopic((ActiveMQDestination)((ActiveMQDestination)topic));
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)topic);
        int count = new ActiveMQPrefetchPolicy().getTopicPrefetch() * 2;
        for (int i = 0; i < count; ++i) {
            BytesMessage m = s.createBytesMessage();
            producer.send((Message)m);
        }
        Message msg = advisoryConsumer.receive(1000L);
        Assert.assertNotNull((Object)msg);
        ActiveMQMessage message = (ActiveMQMessage)msg;
        Assert.assertEquals((Object)message.getProperty("orignalDestination"), (Object)((ActiveMQDestination)topic).getQualifiedName());
    }

    @Test(timeout=60000L)
    public void testMessageDeliveryVTAdvisory() throws Exception {
        Session s = this.connection.createSession(false, 1);
        ActiveMQTopic vt = new ActiveMQTopic("VirtualTopic.TEST");
        ActiveMQQueue a = new ActiveMQQueue("Consumer.A.VirtualTopic.TEST");
        MessageConsumer consumer = s.createConsumer((Destination)a);
        ActiveMQQueue b = new ActiveMQQueue("Consumer.B.VirtualTopic.TEST");
        MessageConsumer consumerB = s.createConsumer((Destination)b);
        Assert.assertNotNull((Object)consumer);
        Assert.assertNotNull((Object)consumerB);
        HashSet<String> dests = new HashSet<String>();
        dests.add(vt.getQualifiedName());
        dests.add(a.getQualifiedName());
        dests.add(b.getQualifiedName());
        ActiveMQTopic advisoryTopic = new ActiveMQTopic("ActiveMQ.Advisory.MessageDelivered.>");
        MessageConsumer advisoryConsumer = s.createConsumer((Destination)advisoryTopic);
        MessageProducer producer = s.createProducer((Destination)vt);
        BytesMessage m = s.createBytesMessage();
        m.writeBytes(new byte[1024]);
        producer.send((Message)m);
        Message msg = null;
        while ((msg = advisoryConsumer.receive(1000L)) != null) {
            ActiveMQMessage message = (ActiveMQMessage)msg;
            String dest = (String)message.getProperty("orignalDestination");
            dests.remove(dest);
        }
        Assert.assertTrue((String)("Got delivered for all: " + dests), (boolean)dests.isEmpty());
    }

    @Before
    public void setUp() throws Exception {
        if (this.broker == null) {
            this.broker = this.createBroker();
        }
        ActiveMQConnectionFactory factory = this.createConnectionFactory();
        this.connection = factory.createConnection();
        this.connection.start();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(ActiveMQConnection.DEFAULT_BROKER_URL);
        return cf;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        this.configureBroker(answer);
        answer.start();
        return answer;
    }

    protected void configureBroker(BrokerService answer) throws Exception {
        answer.setPersistent(false);
        PolicyEntry policy = new PolicyEntry();
        policy.setExpireMessagesPeriod(10000L);
        policy.setAdvisoryForFastProducers(true);
        policy.setAdvisoryForConsumed(true);
        policy.setAdvisoryForDelivery(true);
        policy.setAdvisoryForDiscardingMessages(true);
        policy.setAdvisoryForSlowConsumers(true);
        policy.setAdvisoryWhenFull(true);
        policy.setProducerFlowControl(false);
        ConstantPendingMessageLimitStrategy strategy = new ConstantPendingMessageLimitStrategy();
        strategy.setLimit(10);
        policy.setPendingMessageLimitStrategy((PendingMessageLimitStrategy)strategy);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        answer.setDestinationPolicy(pMap);
        answer.addConnector(this.bindAddress);
        answer.setDeleteAllMessagesOnStartup(true);
    }
}

