/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.openwire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.activemq.openwire.OpenWireFormat;
import org.junit.Assert;

public abstract class DataFileGenerator
extends Assert {
    static final File MODULE_BASE_DIR = new File(System.getProperty("basedir", "."));
    static final File CONTROL_DIR = new File(MODULE_BASE_DIR, "src/test/resources/openwire-control");
    static final File CLASS_FILE_DIR = new File(MODULE_BASE_DIR, "src/test/java/org/apache/activemq/openwire");

    public static void main(String[] args) throws Exception {
        DataFileGenerator.generateControlFiles();
    }

    public static ArrayList<DataFileGenerator> getAllDataFileGenerators() throws Exception {
        ArrayList<DataFileGenerator> l = new ArrayList<DataFileGenerator>();
        File[] files = CLASS_FILE_DIR.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().endsWith("Data.java")) continue;
            String cn = file.getName();
            cn = cn.substring(0, cn.length() - ".java".length());
            Class<?> clazz = DataFileGenerator.class.getClassLoader().loadClass("org.apache.activemq.openwire." + cn);
            l.add((DataFileGenerator)((Object)clazz.newInstance()));
        }
        return l;
    }

    private static void generateControlFiles() throws Exception {
        ArrayList<DataFileGenerator> generators = DataFileGenerator.getAllDataFileGenerators();
        for (DataFileGenerator element : generators) {
            try {
                element.generateControlFile();
            }
            catch (Exception exception) {}
        }
    }

    public void generateControlFile() throws Exception {
        CONTROL_DIR.mkdirs();
        File dataFile = new File(CONTROL_DIR, ((Object)((Object)this)).getClass().getName() + ".bin");
        OpenWireFormat wf = new OpenWireFormat();
        wf.setCacheEnabled(false);
        wf.setStackTraceEnabled(false);
        wf.setVersion(1);
        FileOutputStream os = new FileOutputStream(dataFile);
        DataOutputStream ds = new DataOutputStream(os);
        wf.marshal(this.createObject(), (DataOutput)ds);
        ds.close();
    }

    public InputStream generateInputStream() throws Exception {
        OpenWireFormat wf = new OpenWireFormat();
        wf.setCacheEnabled(false);
        wf.setStackTraceEnabled(false);
        wf.setVersion(1);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream ds = new DataOutputStream(os);
        wf.marshal(this.createObject(), (DataOutput)ds);
        ds.close();
        return new ByteArrayInputStream(os.toByteArray());
    }

    public static void assertAllControlFileAreEqual() throws Exception {
        ArrayList<DataFileGenerator> generators = DataFileGenerator.getAllDataFileGenerators();
        for (DataFileGenerator element : generators) {
            element.assertControlFileIsEqual();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertControlFileIsEqual() throws Exception {
        File dataFile = new File(CONTROL_DIR, ((Object)((Object)this)).getClass().getName() + ".bin");
        int pos = 0;
        try (FileInputStream is1 = new FileInputStream(dataFile);){
            InputStream is2 = this.generateInputStream();
            int a = is1.read();
            int b = is2.read();
            DataFileGenerator.assertEquals((String)("Data does not match control file: " + dataFile + " at byte position " + ++pos), (long)a, (long)b);
            while (a >= 0 && b >= 0) {
                a = is1.read();
                b = is2.read();
                ++pos;
                DataFileGenerator.assertEquals((long)a, (long)b);
            }
            is2.close();
        }
    }

    protected abstract Object createObject() throws IOException;
}

