/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.util.Timer;
import java.util.TimerTask;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;

public class TcpTransportBindTest
extends EmbeddedBrokerTestSupport {
    String addr = "tcp://localhost:0";

    @Override
    protected void setUp() throws Exception {
        this.bindAddress = this.addr + "?transport.reuseAddress=true&transport.soTimeout=1000";
        super.setUp();
        this.addr = ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = new BrokerService();
        answer.setBrokerName("TcpTransportBindTest");
        answer.setPersistent(false);
        answer.setUseJmx(false);
        answer.addConnector(this.bindAddress);
        return answer;
    }

    public void testConnect() throws Exception {
        Connection connection = new ActiveMQConnectionFactory(this.addr).createConnection();
        connection.start();
    }

    public void testReceiveThrowsException() throws Exception {
        Connection connection = new ActiveMQConnectionFactory(this.addr).createConnection();
        connection.start();
        Session sess = connection.createSession(false, 1);
        MessageConsumer consumer = sess.createConsumer((Destination)this.createDestination());
        Timer timer = new Timer();
        class StopTask
        extends TimerTask {
            StopTask() {
            }

            @Override
            public void run() {
                try {
                    TcpTransportBindTest.this.broker.stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        timer.schedule((TimerTask)new StopTask(), 1000L);
        try {
            consumer.receive(30000L);
            TcpTransportBindTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

