/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import javax.jms.Connection;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import junit.framework.Test;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableSubscriptionRemoveOfflineTest
extends EmbeddedBrokerTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionRemoveOfflineTest.class);

    @Override
    protected void setUp() throws Exception {
        this.useTopic = true;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected BrokerService createBroker() throws Exception {
        BrokerService answer = super.createBroker();
        answer.setOfflineDurableSubscriberTaskSchedule(3000L);
        answer.setOfflineDurableSubscriberTimeout(5000L);
        answer.setDeleteAllMessagesOnStartup(true);
        return answer;
    }

    protected BrokerService restartBroker() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = null;
        this.broker = super.createBroker();
        this.broker.setOfflineDurableSubscriberTaskSchedule(3000L);
        this.broker.setOfflineDurableSubscriberTimeout(5000L);
        this.broker.start();
        this.broker.waitUntilStarted();
        return this.broker;
    }

    public void testRemove() throws Exception {
        Connection connection = this.createConnection();
        connection.setClientID("cliID");
        connection.start();
        Session session = connection.createSession(false, 1);
        TopicSubscriber subscriber = session.createDurableSubscriber((Topic)this.createDestination(), "subName");
        subscriber.close();
        connection.close();
        DurableSubscriptionRemoveOfflineTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionRemoveOfflineTest.this.broker.getAdminView().getInactiveDurableTopicSubscribers().length == 0;
            }
        }, (long)15000L));
    }

    public void testRemoveAfterRestart() throws Exception {
        Connection connection = this.createConnection();
        connection.setClientID("cliID");
        connection.start();
        Session session = connection.createSession(false, 1);
        TopicSubscriber subscriber = session.createDurableSubscriber((Topic)this.createDestination(), "subName");
        subscriber.close();
        connection.close();
        LOG.info("Broker restarting, wait for inactive cleanup afterwards.");
        this.restartBroker();
        LOG.info("Broker restarted, wait for inactive cleanup now.");
        DurableSubscriptionRemoveOfflineTest.assertTrue((this.broker.getAdminView().getInactiveDurableTopicSubscribers().length == 1 ? 1 : 0) != 0);
        DurableSubscriptionRemoveOfflineTest.assertTrue((boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                return DurableSubscriptionRemoveOfflineTest.this.broker.getAdminView().getInactiveDurableTopicSubscribers().length == 0;
            }
        }, (long)20000L));
    }

    @Override
    protected boolean isPersistent() {
        return true;
    }

    public static Test suite() {
        return DurableSubscriptionRemoveOfflineTest.suite(DurableSubscriptionRemoveOfflineTest.class);
    }
}

