/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ6815Test {
    static final Logger LOG = LoggerFactory.getLogger(AMQ6815Test.class);
    private static final int MEM_LIMIT = 0x500000;
    private static final byte[] payload = new byte[5120];
    protected BrokerService brokerService;
    protected Connection connection;
    protected Session session;
    protected Queue amqDestination;

    @Before
    public void setUp() throws Exception {
        this.brokerService = new BrokerService();
        PolicyEntry policy = new PolicyEntry();
        policy.setMemoryLimit(0x500000L);
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        this.brokerService.setDestinationPolicy(pMap);
        this.brokerService.start();
        this.connection = new ActiveMQConnectionFactory("vm://localhost").createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.amqDestination = this.session.createQueue("QQ");
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        this.brokerService.stop();
    }

    @Test(timeout=120000L)
    public void testHeapUsage() throws Exception {
        Runtime.getRuntime().gc();
        long initUsedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        this.sendMessages(10000);
        Runtime.getRuntime().gc();
        long usedMem = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() - initUsedMemory;
        LOG.info("Mem in use: " + usedMem / 1024L + "K");
        Assert.assertTrue((String)("Used Mem reasonable " + usedMem), (usedMem < 0x1900000L ? 1 : 0) != 0);
    }

    protected void sendMessages(int count) throws JMSException {
        MessageProducer producer = this.session.createProducer((Destination)this.amqDestination);
        for (int i = 0; i < count; ++i) {
            BytesMessage bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(payload);
            producer.send((Message)bytesMessage);
        }
        producer.close();
    }
}

