/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.net.Socket;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.util.DefaultTestAppender;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTransportCloseSocketNoWarnTest {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTransportCloseSocketNoWarnTest.class);
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private BrokerService brokerService;
    final AtomicBoolean gotExceptionInLog = new AtomicBoolean();
    Appender appender = new DefaultTestAppender(){

        public void doAppend(LoggingEvent event) {
            if (event.getLevel().equals((Object)Level.WARN) && event.getRenderedMessage().contains("failed:")) {
                TcpTransportCloseSocketNoWarnTest.this.gotExceptionInLog.set(Boolean.TRUE);
                LOG.error("got event: " + event + ", ex:" + event.getRenderedMessage());
                LOG.error("Event source: ", new Throwable("Here"));
            }
        }
    };

    @Before
    public void before() throws Exception {
        this.brokerService = new BrokerService();
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        org.apache.log4j.Logger.getRootLogger().addAppender(this.appender);
        org.apache.log4j.Logger.getLogger((String)(TransportConnection.class.getName() + ".Transport")).setLevel(Level.WARN);
    }

    @After
    public void after() throws Exception {
        if (this.brokerService != null) {
            this.brokerService.stop();
            this.brokerService.waitUntilStopped();
        }
        org.apache.log4j.Logger.getRootLogger().removeAppender(this.appender);
    }

    @Test(timeout=60000L)
    public void testNoWarn() throws Exception {
        this.doTest(false);
    }

    @Test(timeout=60000L)
    public void testWarn() throws Exception {
        this.doTest(true);
    }

    protected void doTest(boolean warn) throws Exception {
        for (String protocol : new String[]{"tcp", "ssl", "stomp"}) {
            TransportConnector transportConnector = this.brokerService.addConnector(protocol + "://localhost:0");
            transportConnector.setWarnOnRemoteClose(warn);
        }
        this.brokerService = this.brokerService;
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        for (TransportConnector transportConnector : this.brokerService.getTransportConnectors()) {
            Socket socket;
            URI uri = transportConnector.getPublishableConnectURI();
            if (uri.getScheme().equals("ssl")) {
                SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket("127.0.0.1", uri.getPort());
                final CountDownLatch doneHandShake = new CountDownLatch(1);
                sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                    @Override
                    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        doneHandShake.countDown();
                    }
                });
                sslSocket.startHandshake();
                Assert.assertTrue((String)"handshake done", (boolean)doneHandShake.await(10L, TimeUnit.SECONDS));
                socket = sslSocket;
            } else {
                socket = new Socket("127.0.0.1", uri.getPort());
            }
            TimeUnit.SECONDS.sleep(1L);
            LOG.info("testing socket: " + socket);
            socket.close();
        }
        Assert.assertEquals((String)"warn|no warn in log", (Object)warn, (Object)this.gotExceptionInLog.get());
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
    }
}

