/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.io.File;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.network.NetworkConnector;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.util.LargeFile;
import org.apache.activemq.util.StoreUtil;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StoreUtil.class})
public class BrokerServiceTest
extends TestCase {
    public void testAddRemoveTransportsWithJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setUseJmx(true);
        service.setPersistent(false);
        TransportConnector connector = service.addConnector("tcp://localhost:0");
        service.start();
        service.removeConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testAddRemoveTransportsWithoutJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(false);
        TransportConnector connector = service.addConnector("tcp://localhost:0");
        service.start();
        service.removeConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testAddRemoveNetworkWithJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(true);
        NetworkConnector connector = service.addNetworkConnector("multicast://default?group=group-" + System.currentTimeMillis());
        service.start();
        service.removeNetworkConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testAddRemoveNetworkWithoutJMX() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(false);
        NetworkConnector connector = service.addNetworkConnector("multicast://default?group=group-" + System.currentTimeMillis());
        service.start();
        service.removeNetworkConnector(connector);
        connector.stop();
        service.stop();
    }

    public void testSystemUsage() {
        BrokerService service = new BrokerService();
        BrokerServiceTest.assertEquals((long)0x40000000L, (long)service.getSystemUsage().getMemoryUsage().getLimit());
        BrokerServiceTest.assertEquals((long)0xC80000000L, (long)service.getSystemUsage().getTempUsage().getLimit());
        BrokerServiceTest.assertEquals((long)0x1900000000L, (long)service.getSystemUsage().getStoreUsage().getLimit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLargeFileSystem() throws Exception {
        BrokerService service = new BrokerService();
        File dataDirectory = new File(service.getBrokerDataDirectory(), "KahaDB");
        File tmpDataDirectory = service.getTmpDataDirectory();
        PersistenceAdapter persistenceAdapter = service.createPersistenceAdapter();
        persistenceAdapter.setDirectory(dataDirectory);
        service.setPersistenceAdapter(persistenceAdapter);
        service.setUseJmx(false);
        PowerMockito.mockStatic(StoreUtil.class, (Class[])new Class[0]);
        PowerMockito.when((Object)StoreUtil.findParentDirectory((File)dataDirectory)).thenReturn((Object)new LargeFile(dataDirectory.getParentFile(), "KahaDB"));
        PowerMockito.when((Object)StoreUtil.findParentDirectory((File)tmpDataDirectory)).thenReturn((Object)tmpDataDirectory.getParentFile());
        try {
            service.start();
            BrokerServiceTest.fail((String)"Expect error on negative totalspace");
        }
        catch (Exception expected) {
            BrokerServiceTest.assertTrue((boolean)expected.getLocalizedMessage().contains("negative"));
        }
        finally {
            service.stop();
        }
        service.getSystemUsage().getStoreUsage().setTotal(service.getSystemUsage().getStoreUsage().getLimit() * 2L);
        service.start(true);
        service.stop();
        PowerMockito.verifyStatic();
    }
}

