/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.ConnectionStatistics;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionControl;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.state.ProducerState;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.usage.MemoryUsage;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueOptimizedDispatchExceptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(QueueOptimizedDispatchExceptionTest.class);
    private static final String brokerName = "testBroker";
    private static final String brokerUrl = "vm://testBroker";
    private static final int count = 50;
    private static final String mesageIdRoot = "11111:22222:";
    private final ActiveMQQueue destination = new ActiveMQQueue("queue-" + QueueOptimizedDispatchExceptionTest.class.getSimpleName());
    private final int messageBytesSize = 256;
    private final String text = new String(new byte[256]);
    private BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setBrokerName(brokerName);
        this.broker.setPersistent(false);
        this.broker.setSchedulerSupport(false);
        this.broker.setUseJmx(false);
        this.broker.setUseShutdownHook(false);
        this.broker.addConnector(brokerUrl);
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    @Test
    public void TestOptimizedDispatchCME() throws Exception {
        PersistenceAdapter persistenceAdapter = this.broker.getPersistenceAdapter();
        MessageStore queueMessageStore = persistenceAdapter.createQueueMessageStore(this.destination);
        ConnectionContext contextNotInTx = new ConnectionContext();
        contextNotInTx.setConnection(new Connection(){

            public void stop() throws Exception {
            }

            public void start() throws Exception {
            }

            public void updateClient(ConnectionControl control) {
            }

            public void serviceExceptionAsync(IOException e) {
            }

            public void serviceException(Throwable error) {
            }

            public Response service(Command command) {
                return null;
            }

            public boolean isSlow() {
                return false;
            }

            public boolean isNetworkConnection() {
                return false;
            }

            public boolean isManageable() {
                return false;
            }

            public boolean isFaultTolerantConnection() {
                return false;
            }

            public boolean isConnected() {
                return true;
            }

            public boolean isBlocked() {
                return false;
            }

            public boolean isActive() {
                return false;
            }

            public ConnectionStatistics getStatistics() {
                return null;
            }

            public String getRemoteAddress() {
                return null;
            }

            public int getDispatchQueueSize() {
                return 0;
            }

            public Connector getConnector() {
                return null;
            }

            public String getConnectionId() {
                return null;
            }

            public void dispatchSync(Command message) {
            }

            public void dispatchAsync(Command command) {
            }

            public int getActiveTransactionCount() {
                return 0;
            }

            public Long getOldestActiveTransactionDuration() {
                return null;
            }
        });
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        Queue queue = new Queue(this.broker, (ActiveMQDestination)this.destination, queueMessageStore, destinationStatistics, this.broker.getTaskRunnerFactory());
        MockMemoryUsage usage = new MockMemoryUsage();
        queue.setOptimizedDispatch(true);
        queue.initialize();
        queue.start();
        queue.memoryUsage = usage;
        ProducerBrokerExchange producerExchange = new ProducerBrokerExchange();
        ProducerInfo producerInfo = new ProducerInfo();
        ProducerState producerState = new ProducerState(producerInfo);
        producerExchange.setProducerState(producerState);
        producerExchange.setConnectionContext(contextNotInTx);
        for (int i = 0; i < 50; ++i) {
            Message message = this.getMessage(i);
            queue.send(producerExchange, message);
        }
        usage.setFull(false);
        try {
            queue.wakeup();
        }
        catch (Exception e) {
            LOG.error("Queue threw an unexpected exception: " + e.toString());
            Assert.fail((String)"Should not throw an exception.");
        }
    }

    private Message getMessage(int i) throws Exception {
        ActiveMQTextMessage message = new ActiveMQTextMessage();
        message.setMessageId(new MessageId(mesageIdRoot + i));
        message.setDestination((ActiveMQDestination)this.destination);
        message.setPersistent(false);
        message.setResponseRequired(true);
        message.setText("Msg:" + i + " " + this.text);
        Assert.assertEquals((long)message.getMessageId().getProducerSequenceId(), (long)i);
        return message;
    }

    private class MockMemoryUsage
    extends MemoryUsage {
        private boolean full = true;

        private MockMemoryUsage() {
        }

        public void setFull(boolean full) {
            this.full = full;
        }

        public boolean isFull() {
            return this.full;
        }
    }
}

