/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.command.ActiveMQTextMessage;
import org.apache.activemq.test.TestSupport;

public class AbstractStoreCursorNpeTest
extends TestSupport {
    protected Connection connection;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Topic destination;

    public void testSetLastCachedIdNPE() throws Exception {
        this.connection = this.createConnection();
        this.connection.setClientID("clientId");
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        this.destination = this.session.createTopic("test.topic");
        this.producer = this.session.createProducer((Destination)this.destination);
        this.producer.setDeliveryMode(2);
        Connection durableCon = this.createConnection();
        durableCon.setClientID("testCons");
        durableCon.start();
        final Session durSession = durableCon.createSession(false, 1);
        ExecutorService executorService = Executors.newCachedThreadPool();
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        TopicSubscriber cons = durSession.createDurableSubscriber(durSession.createTopic("test.topic"), "sub1");
                        Thread.sleep(100L);
                        cons.close();
                        durSession.unsubscribe("sub1");
                    }
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                    return;
                }
            }
        });
        ActiveMQTextMessage myMessage = new ActiveMQTextMessage();
        myMessage.setText("test");
        for (int i = 0; i < 10000; ++i) {
            this.producer.send((Message)myMessage);
        }
    }
}

