/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.lang.reflect.Field;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class AMQ6599Test {
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";
    private String uri;
    private final String protocol;
    private BrokerService brokerService;

    @Parameterized.Parameters(name="protocol={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"nio+ssl"}, {"ssl"}, {"tcp"}, {"nio"});
    }

    @Before
    public void before() throws Exception {
        BrokerService brokerService = new BrokerService();
        brokerService.setPersistent(false);
        TransportConnector connector = brokerService.addConnector(this.protocol + "://localhost:0?transport.soTimeout=3500");
        connector.setName("connector");
        this.uri = connector.getPublishableConnectString();
        this.brokerService = brokerService;
        brokerService.start();
        brokerService.waitUntilStarted();
    }

    @After
    public void after() throws Exception {
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    public AMQ6599Test(String protocol) {
        this.protocol = protocol;
    }

    @Test(timeout=30000L)
    public void testSoTimeout() throws Exception {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
        factory.setBrokerURL(this.uri);
        factory.createConnection().start();
        for (TransportConnection connection : this.brokerService.getTransportConnectorByName("connector").getConnections()) {
            TcpTransport tcpTransport = (TcpTransport)connection.getTransport().narrow(TcpTransport.class);
            Field socketField = TcpTransport.class.getDeclaredField("socket");
            socketField.setAccessible(true);
            Socket socket = (Socket)socketField.get(tcpTransport);
            Assert.assertEquals((long)3500L, (long)tcpTransport.getSoTimeout());
            Assert.assertEquals((long)3500L, (long)socket.getSoTimeout());
        }
    }

    static {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
    }
}

