/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs.amq1095;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import junit.framework.TestCase;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQTopic;

public class ActiveMQTestCase
extends TestCase {
    private Context context;
    private BrokerService broker;
    protected Connection connection;
    protected Destination destination;
    private final List<MessageConsumer> consumersToEmpty = new LinkedList<MessageConsumer>();
    protected final long RECEIVE_TIMEOUT = 500L;

    public ActiveMQTestCase() {
    }

    public ActiveMQTestCase(String name) {
        super(name);
    }

    protected void setUp() {
        try {
            Properties systemProperties = System.getProperties();
            Properties jndiProperties = new Properties();
            for (String string : systemProperties.keySet()) {
                if (!string.startsWith("java.naming.") && !string.startsWith("topic.") && !string.startsWith("queue.")) continue;
                String value = (String)systemProperties.get(string);
                jndiProperties.put(string, value);
            }
            this.context = new InitialContext(jndiProperties);
            URI uri = new URI("xbean:org/apache/activemq/bugs/amq1095/activemq.xml");
            this.broker = BrokerFactory.createBroker((URI)uri);
            this.broker.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)this.context.lookup("TopicConnectionFactory");
            this.destination = new ActiveMQTopic("TestTopic");
            this.connection = connectionFactory.createConnection();
            this.connection.setClientID("sampleClientID");
        }
        catch (JMSException ex1) {
            ex1.printStackTrace();
            ActiveMQTestCase.fail((String)ex1.toString());
        }
        catch (NamingException ex2) {
            ex2.printStackTrace();
            ActiveMQTestCase.fail((String)ex2.toString());
        }
        catch (Throwable ex3) {
            ex3.printStackTrace();
            ActiveMQTestCase.fail((String)ex3.toString());
        }
    }

    protected void tearDown() throws Exception {
        try {
            for (MessageConsumer consumer : this.consumersToEmpty) {
                TextMessage msg;
                if (consumer == null) continue;
                while ((msg = (TextMessage)consumer.receive(500L)) != null) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.connection != null) {
            this.connection.stop();
        }
        this.broker.stop();
    }

    protected void registerToBeEmptiedOnShutdown(MessageConsumer consumer) {
        this.consumersToEmpty.add(consumer);
    }
}

