/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.demo;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultQueueSender {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultQueueSender.class);

    private DefaultQueueSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String uri = "tcp://localhost:61616";
        String text = "Hello World!";
        Connection connection = null;
        if (args.length < 1) {
            DefaultQueueSender.printUsage();
            System.exit(1);
        }
        int idx = 0;
        String arg = args[0];
        if (arg.equals("-uri")) {
            if (args.length == 1) {
                DefaultQueueSender.printUsage();
                System.exit(1);
            }
            uri = args[1];
            idx += 2;
        }
        String queueName = args[idx];
        LOG.info("Connecting to: " + uri);
        LOG.info("Queue name is " + queueName);
        if (++idx < args.length) {
            text = args[idx];
        }
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
            connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)destination);
            TextMessage message = session.createTextMessage(text);
            producer.send((Message)message);
        }
        catch (JMSException e) {
            LOG.info("Exception occurred: " + e.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException jMSException) {}
            }
        }
    }

    protected static void printUsage() {
        System.out.println("Usage: java DefaultQueueSender [-uri <connection-uri>] <queue-name> [<message-body>]");
    }
}

