/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.RemoveInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.network.DurableConduitBridge;
import org.apache.activemq.network.NetworkBridgeConfiguration;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportListener;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IMocksControl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetworkRouteTest {
    private IMocksControl control;
    private BrokerService brokerService;
    private Transport localBroker;
    private Transport remoteBroker;
    private TransportListener localListener;
    private TransportListener remoteListener;
    private MessageDispatch msgDispatch;
    private ActiveMQMessage path1Msg;
    private ActiveMQMessage path2Msg;
    private ActiveMQMessage removePath1Msg;
    private ActiveMQMessage removePath2Msg;

    @Test
    public void verifyNoRemoveOnOneConduitRemove() throws Exception {
        this.localBroker.oneway(EasyMock.isA(ConsumerInfo.class));
        this.control.replay();
        this.remoteListener.onCommand((Object)this.path2Msg);
        this.remoteListener.onCommand((Object)this.path1Msg);
        this.remoteListener.onCommand((Object)this.removePath2Msg);
        this.control.verify();
    }

    @Test
    public void addAndRemoveOppositeOrder() throws Exception {
        this.localBroker.oneway(EasyMock.isA(ConsumerInfo.class));
        ArgHolder localConsumer = ArgHolder.holdArgsForLastObjectCall();
        this.remoteBroker.asyncRequest(EasyMock.isA(ActiveMQMessage.class), (ResponseCallback)EasyMock.isA(ResponseCallback.class));
        ArgHolder firstMessageFuture = ArgHolder.holdArgsForLastFutureRequestCall();
        this.localBroker.oneway(EasyMock.isA(MessageAck.class));
        this.remoteBroker.asyncRequest(EasyMock.isA(ActiveMQMessage.class), (ResponseCallback)EasyMock.isA(ResponseCallback.class));
        ArgHolder secondMessageFuture = ArgHolder.holdArgsForLastFutureRequestCall();
        this.localBroker.oneway(EasyMock.isA(MessageAck.class));
        this.localBroker.oneway(EasyMock.isA(RemoveInfo.class));
        ExpectationWaiter waitForRemove = ExpectationWaiter.waiterForLastVoidCall();
        this.control.replay();
        this.remoteListener.onCommand((Object)this.path1Msg);
        localConsumer.latch.await(5L, TimeUnit.SECONDS);
        this.msgDispatch.setConsumerId(((ConsumerInfo)localConsumer.arguments[0]).getConsumerId());
        this.remoteListener.onCommand((Object)this.path2Msg);
        this.localListener.onCommand((Object)this.msgDispatch);
        ResponseCallback callback = (ResponseCallback)firstMessageFuture.arguments[1];
        FutureResponse response = new FutureResponse(callback);
        response.set(new Response());
        this.remoteListener.onCommand((Object)this.removePath2Msg);
        this.localListener.onCommand((Object)this.msgDispatch);
        callback = (ResponseCallback)secondMessageFuture.arguments[1];
        response = new FutureResponse(callback);
        response.set(new Response());
        this.remoteListener.onCommand((Object)this.removePath1Msg);
        waitForRemove.assertHappens(5L, TimeUnit.SECONDS);
        this.localListener.onCommand((Object)this.msgDispatch);
        this.control.verify();
    }

    @Test
    public void addAndRemoveSameOrder() throws Exception {
        this.localBroker.oneway(EasyMock.isA(ConsumerInfo.class));
        ArgHolder localConsumer = ArgHolder.holdArgsForLastObjectCall();
        this.remoteBroker.asyncRequest(EasyMock.isA(ActiveMQMessage.class), (ResponseCallback)EasyMock.isA(ResponseCallback.class));
        ArgHolder firstMessageFuture = ArgHolder.holdArgsForLastFutureRequestCall();
        this.localBroker.oneway(EasyMock.isA(MessageAck.class));
        this.remoteBroker.asyncRequest(EasyMock.isA(ActiveMQMessage.class), (ResponseCallback)EasyMock.isA(ResponseCallback.class));
        ArgHolder secondMessageFuture = ArgHolder.holdArgsForLastFutureRequestCall();
        this.localBroker.oneway(EasyMock.isA(MessageAck.class));
        this.localBroker.oneway(EasyMock.isA(RemoveInfo.class));
        ExpectationWaiter waitForRemove = ExpectationWaiter.waiterForLastVoidCall();
        this.control.replay();
        this.remoteListener.onCommand((Object)this.path1Msg);
        localConsumer.latch.await(5L, TimeUnit.SECONDS);
        this.msgDispatch.setConsumerId(((ConsumerInfo)localConsumer.arguments[0]).getConsumerId());
        this.remoteListener.onCommand((Object)this.path2Msg);
        this.localListener.onCommand((Object)this.msgDispatch);
        ResponseCallback callback = (ResponseCallback)firstMessageFuture.arguments[1];
        FutureResponse response = new FutureResponse(callback);
        response.set(new Response());
        this.remoteListener.onCommand((Object)this.removePath1Msg);
        this.localListener.onCommand((Object)this.msgDispatch);
        callback = (ResponseCallback)secondMessageFuture.arguments[1];
        response = new FutureResponse(callback);
        response.set(new Response());
        this.remoteListener.onCommand((Object)this.removePath2Msg);
        waitForRemove.assertHappens(5L, TimeUnit.SECONDS);
        this.localListener.onCommand((Object)this.msgDispatch);
        this.control.verify();
    }

    @Before
    public void before() throws Exception {
        this.control = EasyMock.createControl();
        this.localBroker = (Transport)this.control.createMock(Transport.class);
        this.remoteBroker = (Transport)this.control.createMock(Transport.class);
        NetworkBridgeConfiguration configuration = new NetworkBridgeConfiguration();
        this.brokerService = new BrokerService();
        BrokerInfo remoteBrokerInfo = new BrokerInfo();
        configuration.setDuplex(true);
        configuration.setNetworkTTL(5);
        this.brokerService.setBrokerId("broker-1");
        this.brokerService.setPersistent(false);
        this.brokerService.setUseJmx(false);
        this.brokerService.start();
        this.brokerService.waitUntilStarted();
        remoteBrokerInfo.setBrokerId(new BrokerId("remote-broker-id"));
        remoteBrokerInfo.setBrokerName("remote-broker-name");
        this.localBroker.setTransportListener((TransportListener)EasyMock.isA(TransportListener.class));
        ArgHolder localListenerRef = ArgHolder.holdArgsForLastVoidCall();
        this.remoteBroker.setTransportListener((TransportListener)EasyMock.isA(TransportListener.class));
        ArgHolder remoteListenerRef = ArgHolder.holdArgsForLastVoidCall();
        this.localBroker.start();
        this.remoteBroker.start();
        this.remoteBroker.oneway(EasyMock.isA(Object.class));
        EasyMock.expectLastCall().times(4);
        this.remoteBroker.oneway(EasyMock.isA(Object.class));
        ExpectationWaiter remoteInitWaiter = ExpectationWaiter.waiterForLastVoidCall();
        this.localBroker.oneway((Object)remoteBrokerInfo);
        EasyMock.expect((Object)this.localBroker.request(EasyMock.isA(Object.class))).andReturn(null);
        this.localBroker.oneway(EasyMock.isA(Object.class));
        ExpectationWaiter localInitWaiter = ExpectationWaiter.waiterForLastVoidCall();
        this.control.replay();
        DurableConduitBridge bridge = new DurableConduitBridge(configuration, this.localBroker, this.remoteBroker);
        bridge.setBrokerService(this.brokerService);
        bridge.start();
        this.localListener = (TransportListener)localListenerRef.getArguments()[0];
        Assert.assertNotNull((Object)this.localListener);
        this.remoteListener = (TransportListener)remoteListenerRef.getArguments()[0];
        Assert.assertNotNull((Object)this.remoteListener);
        this.remoteListener.onCommand((Object)remoteBrokerInfo);
        remoteInitWaiter.assertHappens(5L, TimeUnit.SECONDS);
        localInitWaiter.assertHappens(5L, TimeUnit.SECONDS);
        this.control.verify();
        this.control.reset();
        ActiveMQMessage msg = new ActiveMQMessage();
        msg.setDestination((ActiveMQDestination)new ActiveMQTopic("test"));
        this.msgDispatch = new MessageDispatch();
        this.msgDispatch.setMessage((Message)msg);
        this.msgDispatch.setDestination(msg.getDestination());
        ConsumerInfo path1 = new ConsumerInfo();
        path1.setDestination(msg.getDestination());
        path1.setConsumerId(new ConsumerId(new SessionId(new ConnectionId("conn-id-1"), 1L), 3L));
        path1.setBrokerPath(new BrokerId[]{new BrokerId("remote-broker-id"), new BrokerId("server(1)-broker-id")});
        this.path1Msg = new ActiveMQMessage();
        this.path1Msg.setDestination((ActiveMQDestination)AdvisorySupport.getConsumerAdvisoryTopic((ActiveMQDestination)path1.getDestination()));
        this.path1Msg.setDataStructure((DataStructure)path1);
        ConsumerInfo path2 = new ConsumerInfo();
        path2.setDestination(path1.getDestination());
        path2.setConsumerId(new ConsumerId(new SessionId(new ConnectionId("conn-id-2"), 2L), 4L));
        path2.setBrokerPath(new BrokerId[]{new BrokerId("remote-broker-id"), new BrokerId("server(2)-broker-id"), new BrokerId("server(1)-broker-id")});
        this.path2Msg = new ActiveMQMessage();
        this.path2Msg.setDestination(this.path1Msg.getDestination());
        this.path2Msg.setDataStructure((DataStructure)path2);
        RemoveInfo removePath1 = new RemoveInfo((DataStructure)path1.getConsumerId());
        RemoveInfo removePath2 = new RemoveInfo((DataStructure)path2.getConsumerId());
        this.removePath1Msg = new ActiveMQMessage();
        this.removePath1Msg.setDestination(this.path1Msg.getDestination());
        this.removePath1Msg.setDataStructure((DataStructure)removePath1);
        this.removePath2Msg = new ActiveMQMessage();
        this.removePath2Msg.setDestination(this.path1Msg.getDestination());
        this.removePath2Msg.setDataStructure((DataStructure)removePath2);
    }

    @After
    public void after() throws Exception {
        this.control.reset();
        this.brokerService.stop();
        this.brokerService.waitUntilStopped();
    }

    private static class ExpectationWaiter {
        private CountDownLatch latch = new CountDownLatch(1);

        private ExpectationWaiter() {
        }

        public static ExpectationWaiter waiterForLastVoidCall() {
            final ExpectationWaiter waiter = new ExpectationWaiter();
            EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

                public Object answer() throws Throwable {
                    waiter.latch.countDown();
                    return null;
                }
            });
            return waiter;
        }

        public void assertHappens(long timeout, TimeUnit unit) throws InterruptedException {
            Assert.assertTrue((boolean)this.latch.await(timeout, unit));
        }
    }

    private static class ArgHolder {
        public Object[] arguments;
        final CountDownLatch latch = new CountDownLatch(1);

        private ArgHolder() {
        }

        public static ArgHolder holdArgsForLastVoidCall() {
            final ArgHolder holder = new ArgHolder();
            EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<Object>(){

                public Object answer() throws Throwable {
                    Object[] args = EasyMock.getCurrentArguments();
                    holder.arguments = Arrays.copyOf(args, args.length);
                    return null;
                }
            });
            return holder;
        }

        public static ArgHolder holdArgsForLastObjectCall() {
            final ArgHolder holder = new ArgHolder();
            EasyMock.expect((Object)new Object()).andAnswer((IAnswer)new IAnswer<Object>(){

                public Object answer() throws Throwable {
                    Object[] args = EasyMock.getCurrentArguments();
                    holder.arguments = Arrays.copyOf(args, args.length);
                    holder.latch.countDown();
                    return null;
                }
            });
            return holder;
        }

        public static ArgHolder holdArgsForLastFutureRequestCall() {
            final ArgHolder holder = new ArgHolder();
            EasyMock.expect((Object)new FutureResponse(null)).andAnswer((IAnswer)new IAnswer<FutureResponse>(){

                public FutureResponse answer() throws Throwable {
                    Object[] args = EasyMock.getCurrentArguments();
                    holder.arguments = Arrays.copyOf(args, args.length);
                    return null;
                }
            });
            return holder;
        }

        public Object[] getArguments() {
            Assert.assertNotNull((Object)this.arguments);
            return this.arguments;
        }
    }
}

