/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.nio;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.Session;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOSSThreadLeakTest {
    private static final Logger LOG = LoggerFactory.getLogger(NIOSSThreadLeakTest.class);
    BrokerService broker;
    TransportConnector connector;
    public static final String KEYSTORE_TYPE = "jks";
    public static final String PASSWORD = "password";
    public static final String SERVER_KEYSTORE = "src/test/resources/server.keystore";
    public static final String TRUST_KEYSTORE = "src/test/resources/client.keystore";

    @Before
    public void setUp() throws Exception {
        System.setProperty("javax.net.ssl.trustStore", TRUST_KEYSTORE);
        System.setProperty("javax.net.ssl.trustStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.trustStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStore", SERVER_KEYSTORE);
        System.setProperty("javax.net.ssl.keyStoreType", KEYSTORE_TYPE);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("javax.net.ssl.keyStorePassword", PASSWORD);
        System.setProperty("org.apache.activemq.transport.nio.SelectorManager.maxChannelsPerWorker", "2");
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        this.connector = this.broker.addConnector("nio+ssl://localhost:0?transport.needClientAuth=true");
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    @After
    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
        }
    }

    @Test(timeout=360000L)
    public void testThreadUsage() throws Exception {
        int i;
        final ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("nio+ssl://localhost:" + this.connector.getConnectUri().getPort());
        int threadNumber = 10;
        ExecutorService executorService = Executors.newFixedThreadPool(threadNumber);
        final CountDownLatch[] latch = new CountDownLatch[]{new CountDownLatch(threadNumber)};
        final AtomicInteger errors = new AtomicInteger(0);
        Runnable newConnection = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Connection conn = null;
                try {
                    conn = factory.createConnection();
                    conn.start();
                    Session sess = conn.createSession(false, 1);
                    TimeUnit.MILLISECONDS.sleep(600L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                    latch[0].countDown();
                }
            }
        };
        for (i = 0; i < threadNumber; ++i) {
            executorService.submit(newConnection);
        }
        latch[0].await(5L, TimeUnit.MINUTES);
        LOG.info("First batch...");
        TestCase.assertTrue((boolean)this.noMoreThanXSelectorThreads(threadNumber, this.countSelectorThreads()));
        for (i = 0; i < 4; ++i) {
            LOG.info("batch..." + (i + 2));
            latch[0] = new CountDownLatch(threadNumber);
            for (int j = 0; j < threadNumber; ++j) {
                executorService.submit(newConnection);
            }
            latch[0].await(5L, TimeUnit.MINUTES);
        }
        TestCase.assertTrue((boolean)this.noMoreThanXSelectorThreads(threadNumber, this.countSelectorThreads()));
        LOG.info("errors " + errors.get());
        Assert.assertEquals((long)0L, (long)errors.get());
        executorService.shutdownNow();
    }

    private boolean noMoreThanXSelectorThreads(int expected, int i) {
        boolean result;
        boolean bl = result = i <= expected;
        if (!result) {
            LOG.error("too many threads: " + i);
        }
        return result;
    }

    private int countSelectorThreads() {
        int count = 0;
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        for (long id : thbean.getAllThreadIds()) {
            ThreadInfo threadInfo = thbean.getThreadInfo(id);
            if (threadInfo == null || !threadInfo.getThreadName().contains("Selector Worker:")) continue;
            LOG.info(thbean.getThreadInfo(id).getThreadName());
            ++count;
        }
        return count;
    }
}

