/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.tcp;

import java.net.Socket;
import java.net.URI;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportFilter;
import org.apache.activemq.transport.TransportLogger;
import org.apache.activemq.transport.tcp.TcpTransportServer;

public class TcpTransportServerTest
extends TestCase {
    public void testDefaultPropertiesSetOnTransport() throws Exception {
        TcpTransportServer server = (TcpTransportServer)TransportFactory.bind((URI)new URI("tcp://localhost:61616?trace=true"));
        server.setTransportOption(new HashMap());
        server.setAcceptListener(new TransportAcceptListener(){

            public void onAccept(Transport transport) {
                TestCase.assertTrue((String)"This transport does not have a TransportLogger!!", (boolean)TcpTransportServerTest.this.hasTransportLogger(transport));
            }

            public void onAcceptError(Exception error) {
                TestCase.fail((String)"Should not have received an error!");
            }
        });
        server.start();
        Socket socket = new Socket("localhost", 61616);
        server.handleSocket(socket);
        server.stop();
    }

    private boolean hasTransportLogger(Transport transport) {
        boolean end = false;
        Transport current = transport;
        while (!end) {
            if (current instanceof TransportFilter) {
                TransportFilter filter = (TransportFilter)current;
                if (filter instanceof TransportLogger) {
                    return true;
                }
                current = filter.getNext();
                continue;
            }
            end = true;
        }
        return false;
    }
}

