/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.jms.Destination;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.broker.region.RegionBroker;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.Message;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.usecases.DurableSubscriptionTestSupport;
import org.apache.activemq.util.Wait;

public class JDBCDurableSubscriptionTest
extends DurableSubscriptionTestSupport {
    @Override
    protected PersistenceAdapter createPersistenceAdapter() throws IOException {
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        jdbc.setCleanupPeriod(1000);
        return jdbc;
    }

    public void testUnmatchedCleanedUpOnExpiry() throws Exception {
        final ActiveMQTopic activeMQTopic = new ActiveMQTopic("TestSelectorNoMatchCleanupOnExpired");
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.getDeadLetterStrategy().setProcessExpired(false);
        policyMap.put((ActiveMQDestination)activeMQTopic, (Object)policyEntry);
        this.broker.setDestinationPolicy(policyMap);
        this.broker.setEnableMessageExpirationOnActiveDurableSubs(true);
        Session session = this.connection.createSession(false, 1);
        Topic topic = session.createTopic(activeMQTopic.getTopicName());
        TopicSubscriber consumer = session.createDurableSubscriber(topic, "sub1", "color='red'", false);
        TopicSubscriber consumerNoMatch = session.createDurableSubscriber(topic, "sub2", "color='green'", false);
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.setDeliveryMode(2);
        producer.setTimeToLive(1000L);
        this.connection.start();
        TextMessage msg = session.createTextMessage();
        msg.setText("Msg:1");
        msg.setStringProperty("color", "blue");
        producer.send((javax.jms.Message)msg);
        msg.setText("Msg:2");
        msg.setStringProperty("color", "red");
        producer.send((javax.jms.Message)msg);
        this.assertTextMessageEquals("Msg:2", consumer.receive(5000L));
        JDBCDurableSubscriptionTest.assertNull((Object)consumerNoMatch.receiveNoWait());
        Connection conn = ((JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).getDataSource().getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT ID FROM ACTIVEMQ_MSGS");
        ResultSet result = statement.executeQuery();
        this.printResults("MSGS", result);
        statement.close();
        statement = conn.prepareStatement("SELECT * FROM ACTIVEMQ_ACKS");
        result = statement.executeQuery();
        this.printResults("ACKS", result);
        statement.close();
        JDBCDurableSubscriptionTest.assertTrue((String)"no messages from browse", (boolean)Wait.waitFor((Wait.Condition)new Wait.Condition(){

            public boolean isSatisified() throws Exception {
                Message[] browseResult = ((org.apache.activemq.broker.region.Destination)((RegionBroker)JDBCDurableSubscriptionTest.this.broker.getRegionBroker()).getTopicRegion().getDestinationMap().get(activeMQTopic)).browse();
                System.err.println("Browse: " + browseResult.length + ", v:" + browseResult);
                for (int i = 0; i < 10; ++i) {
                    ((JDBCPersistenceAdapter)JDBCDurableSubscriptionTest.this.broker.getPersistenceAdapter()).cleanup();
                }
                return browseResult.length == 0;
            }
        }));
        statement = conn.prepareStatement("SELECT ID FROM ACTIVEMQ_MSGS");
        result = statement.executeQuery();
        this.printResults("MSGS-AFTER", result);
        statement.close();
        statement = conn.prepareStatement("SELECT * FROM ACTIVEMQ_ACKS");
        result = statement.executeQuery();
        this.printResults("ACKS-AFTER", result);
        statement.close();
        statement = conn.prepareStatement("SELECT * FROM ACTIVEMQ_MSGS");
        result = statement.executeQuery();
        JDBCDurableSubscriptionTest.assertFalse((boolean)result.next());
        conn.close();
    }

    private void printResults(String detail, ResultSet result) throws SQLException {
        System.out.println("**" + detail + "**");
        ResultSetMetaData resultSetMetaData = result.getMetaData();
        int columnsNumber = resultSetMetaData.getColumnCount();
        while (result.next()) {
            for (int i = 1; i <= columnsNumber; ++i) {
                if (i > 1) {
                    System.out.print(",  ");
                }
                String columnValue = result.getString(i);
                System.out.print(columnValue + " " + resultSetMetaData.getColumnName(i));
            }
            System.out.println();
        }
        System.out.println("**" + detail + "** END");
    }
}

