/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.TestSupport;

public class JMSIndividualAckTest
extends TestSupport {
    private Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = this.createConnection();
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        super.tearDown();
    }

    public void testAckedMessageAreConsumed() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 4);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNull((Object)msg);
        session.close();
    }

    public void testLastMessageAcked() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        TextMessage msg1 = session.createTextMessage("msg1");
        TextMessage msg2 = session.createTextMessage("msg2");
        TextMessage msg3 = session.createTextMessage("msg3");
        producer.send((Message)msg1);
        producer.send((Message)msg2);
        producer.send((Message)msg3);
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
        session = this.connection.createSession(false, 4);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        JMSIndividualAckTest.assertEquals((Object)msg1, (Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        JMSIndividualAckTest.assertEquals((Object)msg2, (Object)msg);
        msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNull((Object)msg);
        session.close();
    }

    public void testUnAckedMessageAreNotConsumedOnSessionClose() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Queue queue = session.createQueue(this.getQueueName());
        MessageProducer producer = session.createProducer((Destination)queue);
        producer.send((Message)session.createTextMessage("Hello"));
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        Message msg = consumer.receive(1000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        session.close();
        session = this.connection.createSession(false, 4);
        consumer = session.createConsumer((Destination)queue);
        msg = consumer.receive(2000L);
        JMSIndividualAckTest.assertNotNull((Object)msg);
        msg.acknowledge();
        session.close();
    }

    public void testCreateDurableConsumerFails() throws JMSException {
        this.connection.start();
        Session session = this.connection.createSession(false, 4);
        Topic dest = session.createTopic(this.getName());
        try {
            session.createDurableSubscriber(dest, this.getName());
            JMSIndividualAckTest.fail((String)"Should not be able to create duable subscriber.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String getQueueName() {
        return ((Object)((Object)this)).getClass().getName() + "." + this.getName();
    }
}

