/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.sql.DataSource;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.XARecoveryBrokerTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.derby.jdbc.EmbeddedXADataSource;

public class JdbcXARecoveryBrokerTest
extends XARecoveryBrokerTest {
    EmbeddedXADataSource dataSource;

    @Override
    protected void setUp() throws Exception {
        this.dataSource = new EmbeddedXADataSource();
        this.dataSource.setDatabaseName("derbyDb");
        this.dataSource.setCreateDatabase("create");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.stopDerby();
    }

    @Override
    protected void configureBroker(BrokerService broker) throws Exception {
        super.configureBroker(broker);
        JDBCPersistenceAdapter jdbc = new JDBCPersistenceAdapter();
        jdbc.setDataSource((DataSource)this.dataSource);
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
    }

    @Override
    protected void restartBroker() throws Exception {
        this.broker.stop();
        this.stopDerby();
        this.dataSource = new EmbeddedXADataSource();
        this.dataSource.setDatabaseName("derbyDb");
        this.dataSource.setCreateDatabase("create");
        this.broker = this.createRestartedBroker();
        this.broker.start();
    }

    private void stopDerby() {
        LOG.info("STOPPING DB!@!!!!");
        EmbeddedXADataSource ds = this.dataSource;
        try {
            ds.setShutdownDatabase("shutdown");
            ds.getConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Test suite() {
        return JdbcXARecoveryBrokerTest.suite(JdbcXARecoveryBrokerTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)JdbcXARecoveryBrokerTest.suite());
    }

    @Override
    protected ActiveMQDestination createDestination() {
        return new ActiveMQQueue("test,special");
    }
}

