/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerRestartTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.store.kahadb.KahaDBPersistenceAdapter;
import org.apache.activemq.transport.failover.FailoverTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedeliveryRestartTest
extends BrokerRestartTestSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(RedeliveryRestartTest.class);

    @Override
    protected void setUp() throws Exception {
        this.setAutoFail(true);
        this.setMaxTestTime(120000L);
        super.setUp();
    }

    @Override
    protected void configureBroker(BrokerService broker) throws Exception {
        super.configureBroker(broker);
        KahaDBPersistenceAdapter kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)broker.getPersistenceAdapter();
        kahaDBPersistenceAdapter.setRewriteOnRedelivery(true);
        kahaDBPersistenceAdapter.setCleanupInterval(500L);
        broker.addConnector("tcp://0.0.0.0:0");
    }

    public void testValidateRedeliveryFlagAfterRestart() throws Exception {
        int i;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("failover:(" + ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + ")?jms.transactedIndividualAck=true");
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        this.populateDestination(10, this.queueName, (Connection)connection);
        Session session = connection.createSession(true, 0);
        Queue destination = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        TextMessage msg = null;
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(20000L);
            LOG.info("not redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        }
        session.rollback();
        consumer.close();
        this.restartBroker();
        ((FailoverTransport)connection.getTransport().narrow(FailoverTransport.class)).add(true, ((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString());
        consumer = session.createConsumer((Destination)destination);
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(4000L);
            LOG.info("redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message again", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"redelivery count survives restart", (long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"re delivery flag", (boolean)true, (boolean)msg.getJMSRedelivered());
        }
        session.commit();
        for (i = 0; i < 5; ++i) {
            msg = (TextMessage)consumer.receive(20000L);
            LOG.info("not redelivered? got: " + msg);
            RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
            RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
            RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        }
        session.commit();
        connection.close();
    }

    public void testValidateRedeliveryFlagAfterRecovery() throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + "?jms.transactedIndividualAck=true");
        ActiveMQConnection connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        this.populateDestination(1, this.queueName, (Connection)connection);
        Session session = connection.createSession(true, 0);
        Queue destination = session.createQueue(this.queueName);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        TextMessage msg = (TextMessage)consumer.receive(20000L);
        LOG.info("got: " + msg);
        RedeliveryRestartTest.assertNotNull((String)"got the message", (Object)msg);
        RedeliveryRestartTest.assertEquals((String)"first delivery", (long)1L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        RedeliveryRestartTest.assertEquals((String)"not a redelivery", (boolean)false, (boolean)msg.getJMSRedelivered());
        this.stopBrokerWithStoreFailure();
        this.broker = this.createRestartedBroker();
        this.broker.start();
        connectionFactory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getPublishableConnectString() + "?jms.transactedIndividualAck=true");
        connection = (ActiveMQConnection)connectionFactory.createConnection();
        connection.start();
        session = connection.createSession(true, 0);
        consumer = session.createConsumer((Destination)destination);
        msg = (TextMessage)consumer.receive(10000L);
        RedeliveryRestartTest.assertNotNull((String)"got the message again", (Object)msg);
        RedeliveryRestartTest.assertEquals((String)"redelivery count survives restart", (long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        RedeliveryRestartTest.assertEquals((String)"re delivery flag", (boolean)true, (boolean)msg.getJMSRedelivered());
        session.commit();
        connection.close();
    }

    protected void stopBrokerWithStoreFailure() throws Exception {
        KahaDBPersistenceAdapter kahaDBPersistenceAdapter = (KahaDBPersistenceAdapter)this.broker.getPersistenceAdapter();
        kahaDBPersistenceAdapter.getStore().getJournal().close();
        this.broker.waitUntilStopped();
    }

    private void populateDestination(int nbMessages, String destinationName, Connection connection) throws JMSException {
        Session session = connection.createSession(false, 1);
        Queue destination = session.createQueue(destinationName);
        MessageProducer producer = session.createProducer((Destination)destination);
        for (int i = 1; i <= nbMessages; ++i) {
            producer.send((Message)session.createTextMessage("<hello id='" + i + "'/>"));
        }
        producer.close();
        session.close();
    }

    public static Test suite() {
        return RedeliveryRestartTest.suite(RedeliveryRestartTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)RedeliveryRestartTest.suite());
    }
}

