/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.log.Log;

public class AMQ3932Test {
    private Connection connection;
    private BrokerService broker;

    @Before
    public void setUp() throws Exception {
        this.broker = new BrokerService();
        this.broker.setPersistent(false);
        this.broker.setUseJmx(false);
        TransportConnector tcpConnector = this.broker.addConnector("tcp://localhost:0");
        this.broker.start();
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory("failover:(" + tcpConnector.getPublishableConnectString() + ")?jms.prefetchPolicy.queuePrefetch=0");
        this.connection = factory.createConnection();
        this.connection.start();
    }

    @After
    public void tearDown() throws Exception {
        this.connection.close();
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
            this.broker = null;
        }
    }

    @Test
    public void testPlainReceiveBlocks() throws Exception {
        Session session = this.connection.createSession(false, 1);
        final MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getClass().getName()));
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = null;
        final CountDownLatch done = new CountDownLatch(1);
        final CountDownLatch started = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    started.countDown();
                    Log.info((String)"Entering into a Sync receive call");
                    consumer.receive();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                done.countDown();
            }
        });
        Assert.assertTrue((boolean)started.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)done.await(20L, TimeUnit.SECONDS));
    }

    @Test
    public void testHungReceiveNoWait() throws Exception {
        Session session = this.connection.createSession(false, 1);
        final MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getClass().getName()));
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = null;
        final CountDownLatch done = new CountDownLatch(1);
        final CountDownLatch started = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    started.countDown();
                    Log.info((String)"Entering into a Sync receiveNoWait call");
                    consumer.receiveNoWait();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                done.countDown();
            }
        });
        Assert.assertTrue((boolean)started.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)done.await(20L, TimeUnit.SECONDS));
    }

    @Test
    public void testHungReceiveTimed() throws Exception {
        Session session = this.connection.createSession(false, 1);
        final MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(this.getClass().getName()));
        this.broker.stop();
        this.broker.waitUntilStopped();
        this.broker = null;
        final CountDownLatch done = new CountDownLatch(1);
        final CountDownLatch started = new CountDownLatch(1);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    started.countDown();
                    Log.info((String)"Entering into a timed Sync receive call");
                    consumer.receive(10L);
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                done.countDown();
            }
        });
        Assert.assertTrue((boolean)started.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)done.await(20L, TimeUnit.SECONDS));
    }
}

