/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.sql.SQLException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.JDBCIOExceptionHandler;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.LeaseDatabaseLocker;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQ4636Test
extends TestCase {
    private static final String MY_TEST_TOPIC = "MY_TEST_TOPIC";
    private static final Logger LOG = LoggerFactory.getLogger(AMQ4636Test.class);
    private String transportUrl = "tcp://0.0.0.0:0";
    private BrokerService broker;
    private TestTransactionContext testTransactionContext;

    protected BrokerService createBroker(boolean withJMX) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(withJMX);
        EmbeddedDataSource embeddedDataSource = (EmbeddedDataSource)DataSourceServiceSupport.createDataSource((String)IOHelper.getDefaultDataDirectory());
        embeddedDataSource.setCreateDatabase("create");
        TestJDBCPersistenceAdapter jdbc = new TestJDBCPersistenceAdapter();
        jdbc.setDataSource((DataSource)embeddedDataSource);
        this.testTransactionContext = new TestTransactionContext(jdbc);
        jdbc.setLockKeepAlivePeriod(1000L);
        LeaseDatabaseLocker leaseDatabaseLocker = new LeaseDatabaseLocker();
        leaseDatabaseLocker.setLockAcquireSleepInterval(2000L);
        jdbc.setLocker((Locker)leaseDatabaseLocker);
        broker.setPersistenceAdapter((PersistenceAdapter)jdbc);
        broker.setIoExceptionHandler((IOExceptionHandler)new JDBCIOExceptionHandler());
        this.transportUrl = broker.addConnector(this.transportUrl).getPublishableConnectString();
        return broker;
    }

    public void testProducerWithDBShutdown() throws Exception {
        this.broker = this.createBroker(false);
        this.broker.deleteAllMessages();
        this.broker.start();
        this.broker.waitUntilStarted();
        LOG.info("***Broker started...");
        String failoverTransportURL = "failover:(" + this.transportUrl + ")?timeout=1000";
        this.createDurableConsumer(MY_TEST_TOPIC, failoverTransportURL);
        this.sendMessage(MY_TEST_TOPIC, failoverTransportURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDurableConsumer(String topic, String transportURL) throws JMSException {
        Connection connection = null;
        LOG.info("*** createDurableConsumer() called ...");
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(transportURL);
            connection = factory.createConnection();
            connection.setClientID("myconn1");
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(topic);
            TopicSubscriber topicSubscriber = session.createDurableSubscriber(destination, "MySub1");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String topic, String transportURL) throws JMSException {
        Connection connection = null;
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(transportURL);
            connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            Topic destination = session.createTopic(topic);
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(2);
            TextMessage m = session.createTextMessage("testMessage");
            LOG.info("*** send message to broker...");
            this.testTransactionContext.throwSQLException = true;
            producer.send((Message)m);
            LOG.info("*** Finished send message to broker");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public class TestTransactionContext
    extends TransactionContext {
        public boolean throwSQLException;

        public TestTransactionContext(JDBCPersistenceAdapter jdbcPersistenceAdapter) throws IOException {
            super(jdbcPersistenceAdapter);
        }

        public void executeBatch() throws SQLException {
            if (this.throwSQLException) {
                this.throwSQLException = false;
                throw new SQLException("TEST SQL EXCEPTION");
            }
            super.executeBatch();
        }
    }

    public class TestJDBCPersistenceAdapter
    extends JDBCPersistenceAdapter {
        public TransactionContext getTransactionContext() throws IOException {
            return AMQ4636Test.this.testTransactionContext;
        }
    }
}

