/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.bugs;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.sql.DataSource;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.Locker;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.jdbc.DataSourceServiceSupport;
import org.apache.activemq.store.jdbc.JDBCIOExceptionHandler;
import org.apache.activemq.store.jdbc.JDBCPersistenceAdapter;
import org.apache.activemq.store.jdbc.LeaseDatabaseLocker;
import org.apache.activemq.store.jdbc.TransactionContext;
import org.apache.activemq.util.IOExceptionHandler;
import org.apache.activemq.util.IOHelper;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrapMessageInJDBCStoreTest
extends TestCase {
    private static final String MY_TEST_Q = "MY_TEST_Q";
    private static final Logger LOG = LoggerFactory.getLogger(TrapMessageInJDBCStoreTest.class);
    private String transportUrl = "tcp://127.0.0.1:0";
    private BrokerService broker;
    private TestTransactionContext testTransactionContext;
    private TestJDBCPersistenceAdapter jdbc;

    protected BrokerService createBroker(boolean withJMX) throws Exception {
        BrokerService broker = new BrokerService();
        broker.setUseJmx(withJMX);
        EmbeddedDataSource embeddedDataSource = (EmbeddedDataSource)DataSourceServiceSupport.createDataSource((String)IOHelper.getDefaultDataDirectory());
        embeddedDataSource.setCreateDatabase("create");
        this.jdbc = new TestJDBCPersistenceAdapter();
        this.jdbc.setDataSource((DataSource)embeddedDataSource);
        this.testTransactionContext = new TestTransactionContext(this.jdbc);
        this.jdbc.setLockKeepAlivePeriod(1000L);
        LeaseDatabaseLocker leaseDatabaseLocker = new LeaseDatabaseLocker();
        leaseDatabaseLocker.setLockAcquireSleepInterval(2000L);
        this.jdbc.setLocker((Locker)leaseDatabaseLocker);
        broker.setPersistenceAdapter((PersistenceAdapter)this.jdbc);
        broker.setIoExceptionHandler((IOExceptionHandler)new JDBCIOExceptionHandler());
        this.transportUrl = broker.addConnector(this.transportUrl).getPublishableConnectString();
        return broker;
    }

    public void testDBCommitException() throws Exception {
        this.broker = this.createBroker(false);
        this.broker.deleteAllMessages();
        this.broker.start();
        this.broker.waitUntilStarted();
        LOG.info("***Broker started...");
        String failoverTransportURL = "failover:(" + this.transportUrl + ")?timeout=5000";
        this.sendMessage(MY_TEST_Q, failoverTransportURL);
        List<TextMessage> consumedMessages = this.consumeMessages(MY_TEST_Q, failoverTransportURL);
        ArrayList<Long> dbSeq = this.dbMessageCount();
        LOG.debug("*** db contains message seq " + dbSeq);
        TrapMessageInJDBCStoreTest.assertEquals((String)"number of messages in DB after test", (int)0, (int)dbSeq.size());
        TrapMessageInJDBCStoreTest.assertEquals((String)"number of consumed messages", (int)3, (int)consumedMessages.size());
        this.broker.stop();
        this.broker.waitUntilStopped();
    }

    public List<TextMessage> consumeMessages(String queue, String transportURL) throws JMSException {
        Connection connection = null;
        LOG.debug("*** consumeMessages() called ...");
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(transportURL);
            connection = factory.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(queue);
            ArrayList<TextMessage> consumedMessages = new ArrayList<TextMessage>();
            MessageConsumer messageConsumer = session.createConsumer((Destination)destination);
            while (true) {
                TextMessage textMessage = (TextMessage)messageConsumer.receive(100L);
                LOG.debug("*** consumed Messages :" + textMessage);
                if (textMessage == null) {
                    ArrayList<TextMessage> arrayList = consumedMessages;
                    return arrayList;
                }
                consumedMessages.add(textMessage);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String queue, String transportURL) throws JMSException {
        Connection connection = null;
        try {
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(transportURL);
            connection = factory.createConnection();
            Session session = connection.createSession(false, 1);
            Queue destination = session.createQueue(queue);
            MessageProducer producer = session.createProducer((Destination)destination);
            producer.setDeliveryMode(2);
            TextMessage m = session.createTextMessage("1");
            this.testTransactionContext.throwSQLException = false;
            this.jdbc.throwSQLException = false;
            LOG.debug("*** send message 1 to broker...");
            producer.send((Message)m);
            this.testTransactionContext.throwSQLException = true;
            this.jdbc.throwSQLException = true;
            LOG.debug("***  send message 2 to broker");
            m.setText("2");
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.schedule(new Runnable(){

                @Override
                public void run() {
                    ((TrapMessageInJDBCStoreTest)TrapMessageInJDBCStoreTest.this).testTransactionContext.throwSQLException = false;
                    ((TrapMessageInJDBCStoreTest)TrapMessageInJDBCStoreTest.this).jdbc.throwSQLException = false;
                }
            }, 2L, TimeUnit.SECONDS);
            producer.send((Message)m);
            LOG.debug("***  send  message 3 to broker");
            m.setText("3");
            producer.send((Message)m);
            LOG.debug("*** Finished sending messages to broker");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Long> dbMessageCount() throws SQLException, IOException {
        java.sql.Connection conn = ((JDBCPersistenceAdapter)this.broker.getPersistenceAdapter()).getDataSource().getConnection();
        PreparedStatement statement = conn.prepareStatement("SELECT MSGID_SEQ FROM ACTIVEMQ_MSGS");
        try {
            ResultSet result = statement.executeQuery();
            ArrayList<Long> dbSeq = new ArrayList<Long>();
            while (result.next()) {
                dbSeq.add(result.getLong(1));
            }
            ArrayList<Long> arrayList = dbSeq;
            return arrayList;
        }
        finally {
            statement.close();
            conn.close();
        }
    }

    public class TestTransactionContext
    extends TransactionContext {
        public boolean throwSQLException;

        public TestTransactionContext(JDBCPersistenceAdapter jdbcPersistenceAdapter) throws IOException {
            super(jdbcPersistenceAdapter);
        }

        public void executeBatch() throws SQLException {
            super.executeBatch();
            if (this.throwSQLException) {
                throw new SQLException("TEST SQL EXCEPTION from executeBatch after super. execution");
            }
        }
    }

    public class TestJDBCPersistenceAdapter
    extends JDBCPersistenceAdapter {
        public boolean throwSQLException;

        public TransactionContext getTransactionContext() throws IOException {
            return TrapMessageInJDBCStoreTest.this.testTransactionContext;
        }

        public void checkpoint(boolean sync) throws IOException {
            if (this.throwSQLException) {
                throw new IOException("checkpoint failed");
            }
            super.checkpoint(sync);
        }
    }
}

