/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.conversions;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.CombinationTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionFactoryImpl;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionImpl;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;

public class AmqpAndMqttTest
extends CombinationTestSupport {
    protected BrokerService broker;
    private TransportConnector amqpConnector;
    private TransportConnector mqttConnector;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = this.createBroker();
        this.broker.start();
        this.broker.waitUntilStarted();
    }

    protected void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
            this.broker.waitUntilStopped();
            this.broker = null;
        }
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        this.amqpConnector = broker.addConnector("amqp://0.0.0.0:0");
        this.mqttConnector = broker.addConnector("mqtt://0.0.0.0:0");
        return broker;
    }

    public void testFromMqttToAmqp() throws Exception {
        Connection amqp = this.createAmqpConnection();
        Session session = amqp.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer((Destination)session.createTopic("topic://FOO"));
        BlockingConnection mqtt = this.createMQTTConnection().blockingConnection();
        mqtt.connect();
        byte[] payload = this.bytes("Hello World");
        mqtt.publish("FOO", payload, QoS.AT_LEAST_ONCE, false);
        mqtt.disconnect();
        Message msg = consumer.receive(5000L);
        AmqpAndMqttTest.assertNotNull((Object)msg);
        AmqpAndMqttTest.assertTrue((boolean)(msg instanceof BytesMessage));
        BytesMessage bmsg = (BytesMessage)msg;
        byte[] actual = new byte[(int)bmsg.getBodyLength()];
        bmsg.readBytes(actual);
        AmqpAndMqttTest.assertTrue((boolean)Arrays.equals(actual, payload));
        amqp.close();
    }

    private byte[] bytes(String value) {
        try {
            return value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected MQTT createMQTTConnection() throws Exception {
        MQTT mqtt = new MQTT();
        mqtt.setConnectAttemptsMax(1L);
        mqtt.setReconnectAttemptsMax(0L);
        mqtt.setHost("localhost", this.mqttConnector.getConnectUri().getPort());
        return mqtt;
    }

    public Connection createAmqpConnection() throws Exception {
        ConnectionFactoryImpl factory = new ConnectionFactoryImpl("localhost", this.amqpConnector.getConnectUri().getPort(), "admin", "password");
        ConnectionImpl connection = factory.createConnection();
        connection.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                exception.printStackTrace();
            }
        });
        connection.start();
        return connection;
    }
}

