/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.vm;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;

public class VMTransportWaitForTest
extends TestCase {
    private static final String VM_BROKER_URI_NO_WAIT = "vm://localhost?broker.persistent=false&create=false";
    private static final String VM_BROKER_URI_WAIT_FOR_START = "vm://localhost?broker.persistent=false&create=false&waitForStart=20000";
    CountDownLatch started = new CountDownLatch(1);
    CountDownLatch gotConnection = new CountDownLatch(1);

    public void testWaitFor() throws Exception {
        try {
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VM_BROKER_URI_NO_WAIT));
            cf.createConnection();
            VMTransportWaitForTest.fail((String)"expect broker not exist exception");
        }
        catch (JMSException expectedOnNoBrokerAndNoCreate) {
            // empty catch block
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    VMTransportWaitForTest.this.started.countDown();
                    ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(new URI(VMTransportWaitForTest.VM_BROKER_URI_WAIT_FOR_START));
                    cf.createConnection();
                    VMTransportWaitForTest.this.gotConnection.countDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    TestCase.fail((String)("unexpected exception: " + e));
                }
            }
        };
        t.start();
        this.started.await(20L, TimeUnit.SECONDS);
        Thread.yield();
        VMTransportWaitForTest.assertFalse((String)"has not got connection", (boolean)this.gotConnection.await(2L, TimeUnit.SECONDS));
        BrokerService broker = new BrokerService();
        broker.setPersistent(false);
        broker.addConnector("tcp://localhost:61616");
        broker.start();
        VMTransportWaitForTest.assertTrue((String)"has got connection", (boolean)this.gotConnection.await(400L, TimeUnit.MILLISECONDS));
        broker.stop();
    }
}

