/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.usecases;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.TestSupport;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestBase;
import org.apache.activemq.usecases.DurableSubscriptionOfflineTestListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.actors.threadpool.Arrays;

@RunWith(value=Parameterized.class)
public class DurableSubscriptionOffline1Test
extends DurableSubscriptionOfflineTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(DurableSubscriptionOffline1Test.class);

    @Parameterized.Parameters(name="{0}-{1}")
    public static Collection<Object[]> getTestParameters() {
        String osName = System.getProperty("os.name");
        LOG.debug("Running on [" + osName + "]");
        ArrayList<TestSupport.PersistenceAdapterChoice> persistenceAdapterChoices = new ArrayList<TestSupport.PersistenceAdapterChoice>();
        persistenceAdapterChoices.add(TestSupport.PersistenceAdapterChoice.KahaDB);
        persistenceAdapterChoices.add(TestSupport.PersistenceAdapterChoice.JDBC);
        if (!osName.equalsIgnoreCase("AIX") && !osName.equalsIgnoreCase("SunOS")) {
            persistenceAdapterChoices.add(TestSupport.PersistenceAdapterChoice.LevelDB);
        }
        ArrayList<Object[]> testParameters = new ArrayList<Object[]>();
        Object[] booleanValues = new Boolean[]{Boolean.FALSE, Boolean.TRUE};
        List booleans = Arrays.asList((Object[])booleanValues);
        for (Boolean booleanValue : booleans) {
            for (TestSupport.PersistenceAdapterChoice persistenceAdapterChoice : persistenceAdapterChoices) {
                Object[] currentChoice = new Object[]{persistenceAdapterChoice, booleanValue};
                testParameters.add(currentChoice);
            }
        }
        return testParameters;
    }

    public DurableSubscriptionOffline1Test(TestSupport.PersistenceAdapterChoice adapter, Boolean usePrioritySupport) {
        this.defaultPersistenceAdapter = adapter;
        this.usePrioritySupport = usePrioritySupport;
        LOG.debug(">>>> Created with adapter {} usePrioritySupport? {}", (Object)this.defaultPersistenceAdapter, (Object)usePrioritySupport);
    }

    @Test
    public void testConsumeOnlyMatchedMessages() throws Exception {
        Connection con = this.createConnection();
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            boolean filter;
            boolean bl = filter = i % 2 == 1;
            if (filter) {
                ++sent;
            }
            Message message = session.createMessage();
            message.setStringProperty("filter", filter ? "true" : "false");
            producer.send((Destination)this.topic, message);
        }
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener = new DurableSubscriptionOfflineTestListener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        Assert.assertEquals((long)sent, (long)listener.count);
    }

    @Test
    public void testVerifyAllConsumedAreAcked() throws Exception {
        Connection con = this.createConnection();
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        con = this.createConnection();
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener = new DurableSubscriptionOfflineTestListener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        LOG.info("Consumed: " + listener.count);
        Assert.assertEquals((long)sent, (long)listener.count);
        con = this.createConnection();
        session = con.createSession(false, 1);
        consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        listener = new DurableSubscriptionOfflineTestListener();
        consumer.setMessageListener((MessageListener)listener);
        Thread.sleep(3000L);
        session.close();
        con.close();
        Assert.assertEquals((long)0L, (long)listener.count);
    }

    @Test
    public void testOfflineSubscriptionCanConsumeAfterOnlineSubs() throws Exception {
        Connection con = this.createConnection("offCli1");
        Session session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        con = this.createConnection("offCli2");
        session = con.createSession(false, 1);
        session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        session.close();
        con.close();
        Connection con2 = this.createConnection("onlineCli1");
        Session session2 = con2.createSession(false, 1);
        TopicSubscriber consumer2 = session2.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener2 = new DurableSubscriptionOfflineTestListener();
        consumer2.setMessageListener((MessageListener)listener2);
        con = this.createConnection();
        session = con.createSession(false, 1);
        MessageProducer producer = session.createProducer(null);
        int sent = 0;
        for (int i = 0; i < 10; ++i) {
            ++sent;
            Message message = session.createMessage();
            message.setStringProperty("filter", "true");
            producer.send((Destination)this.topic, message);
        }
        Thread.sleep(1000L);
        session.close();
        con.close();
        Thread.sleep(3000L);
        session2.close();
        con2.close();
        Assert.assertEquals((long)sent, (long)listener2.count);
        this.broker.stop();
        this.createBroker(false);
        con = this.createConnection("offCli1");
        session = con.createSession(false, 1);
        TopicSubscriber consumer = session.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        Connection con3 = this.createConnection("offCli2");
        Session session3 = con3.createSession(false, 1);
        TopicSubscriber consumer3 = session3.createDurableSubscriber((Topic)this.topic, "SubsId", "filter = 'true'", true);
        DurableSubscriptionOfflineTestListener listener = new DurableSubscriptionOfflineTestListener();
        consumer.setMessageListener((MessageListener)listener);
        DurableSubscriptionOfflineTestListener listener3 = new DurableSubscriptionOfflineTestListener();
        consumer3.setMessageListener((MessageListener)listener3);
        Thread.sleep(3000L);
        session.close();
        con.close();
        session3.close();
        con3.close();
        Assert.assertEquals((long)sent, (long)listener.count);
        Assert.assertEquals((long)sent, (long)listener3.count);
    }
}

