/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.model.EndpointRequiredDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.PollEnricher;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.AggregationStrategyBeanAdapter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,transformation")
@XmlRootElement(name="pollEnrich")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PollEnrichDefinition
extends NoOutputDefinition<PollEnrichDefinition>
implements EndpointRequiredDefinition {
    @XmlAttribute(name="uri")
    private String resourceUri;
    @XmlAttribute(name="ref")
    @Deprecated
    private String resourceRef;
    @XmlAttribute
    @Metadata(defaultValue="-1")
    private Long timeout;
    @XmlAttribute(name="strategyRef")
    private String aggregationStrategyRef;
    @XmlAttribute(name="strategyMethodName")
    private String aggregationStrategyMethodName;
    @XmlAttribute(name="strategyMethodAllowNull")
    private Boolean aggregationStrategyMethodAllowNull;
    @XmlAttribute
    private Boolean aggregateOnException;
    @XmlTransient
    private AggregationStrategy aggregationStrategy;

    public PollEnrichDefinition() {
    }

    public PollEnrichDefinition(AggregationStrategy aggregationStrategy, String resourceUri, long timeout) {
        this.aggregationStrategy = aggregationStrategy;
        this.resourceUri = resourceUri;
        this.timeout = timeout;
    }

    public String toString() {
        return "PollEnrich[" + this.description() + " " + this.aggregationStrategy + "]";
    }

    protected String description() {
        return FromDefinition.description(this.getResourceUri(), this.getResourceRef(), null);
    }

    @Override
    public String getLabel() {
        return "pollEnrich[" + this.description() + "]";
    }

    @Override
    public String getEndpointUri() {
        if (this.resourceUri != null) {
            return this.resourceUri;
        }
        return null;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        if (ObjectHelper.isEmpty(this.resourceUri) && ObjectHelper.isEmpty(this.resourceRef)) {
            throw new IllegalArgumentException("Either uri or ref must be provided for resource endpoint");
        }
        Endpoint endpoint = this.resourceUri != null ? routeContext.resolveEndpoint(this.resourceUri) : routeContext.resolveEndpoint(null, this.resourceRef);
        PollEnricher enricher = this.timeout != null ? new PollEnricher(null, endpoint.createPollingConsumer(), this.timeout) : new PollEnricher(null, endpoint.createPollingConsumer(), -1L);
        AggregationStrategy strategy = this.createAggregationStrategy(routeContext);
        if (strategy == null) {
            enricher.setDefaultAggregationStrategy();
        } else {
            enricher.setAggregationStrategy(strategy);
        }
        if (this.getAggregateOnException() != null) {
            enricher.setAggregateOnException(this.getAggregateOnException());
        }
        return enricher;
    }

    private AggregationStrategy createAggregationStrategy(RouteContext routeContext) {
        AggregationStrategy strategy = this.getAggregationStrategy();
        if (strategy == null && this.aggregationStrategyRef != null) {
            Object aggStrategy = routeContext.lookup(this.aggregationStrategyRef, Object.class);
            if (aggStrategy instanceof AggregationStrategy) {
                strategy = (AggregationStrategy)aggStrategy;
            } else if (aggStrategy != null) {
                AggregationStrategyBeanAdapter adapter = new AggregationStrategyBeanAdapter(aggStrategy, this.getAggregationStrategyMethodName());
                if (this.getAggregationStrategyMethodAllowNull() != null) {
                    adapter.setAllowNullNewExchange(this.getAggregationStrategyMethodAllowNull());
                    adapter.setAllowNullOldExchange(this.getAggregationStrategyMethodAllowNull());
                }
                strategy = adapter;
            } else {
                throw new IllegalArgumentException("Cannot find AggregationStrategy in Registry with name: " + this.aggregationStrategyRef);
            }
        }
        if (strategy != null && strategy instanceof CamelContextAware) {
            ((CamelContextAware)((Object)strategy)).setCamelContext(routeContext.getCamelContext());
        }
        return strategy;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }

    public String getResourceRef() {
        return this.resourceRef;
    }

    @Deprecated
    public void setResourceRef(String resourceRef) {
        this.resourceRef = resourceRef;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public String getAggregationStrategyRef() {
        return this.aggregationStrategyRef;
    }

    public void setAggregationStrategyRef(String aggregationStrategyRef) {
        this.aggregationStrategyRef = aggregationStrategyRef;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public Boolean getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(Boolean aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public Boolean getAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(Boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }
}

