/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport;

import java.util.Map;
import org.apache.activemq.util.IntrospectionSupport;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;

public class SocketConnectorFactory {
    private Map<String, Object> transportOptions;

    public Connector createConnector(Server server) throws Exception {
        Connector connector = null;
        try {
            connector = (Connector)Class.forName("org.eclipse.jetty.server.nio.SelectChannelConnector", true, Server.class.getClassLoader()).newInstance();
        }
        catch (Throwable t) {
            Class<?> c = Class.forName("org.eclipse.jetty.server.ServerConnector", true, Server.class.getClassLoader());
            connector = (Connector)c.getConstructor(Server.class).newInstance(server);
            Server.class.getMethod("setStopTimeout", Long.TYPE).invoke((Object)server, 500);
            connector.getClass().getMethod("setStopTimeout", Long.TYPE).invoke((Object)connector, 500);
        }
        if (this.transportOptions != null) {
            IntrospectionSupport.setProperties((Object)connector, this.transportOptions, (String)"");
        }
        return connector;
    }

    public Map<String, Object> getTransportOptions() {
        return this.transportOptions;
    }

    public void setTransportOptions(Map<String, Object> transportOptions) {
        this.transportOptions = transportOptions;
    }
}

