/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.http;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportLoggerFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.http.HttpClientTransport;
import org.apache.activemq.transport.http.HttpInactivityMonitor;
import org.apache.activemq.transport.http.HttpTransportServer;
import org.apache.activemq.transport.util.TextWireFormat;
import org.apache.activemq.transport.xstream.XStreamWireFormat;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTransportFactory
extends TransportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HttpTransportFactory.class);

    public TransportServer doBind(URI location) throws IOException {
        try {
            HashMap options = new HashMap(URISupport.parseParameters((URI)location));
            HttpTransportServer result = new HttpTransportServer(location, this);
            Map transportOptions = IntrospectionSupport.extractProperties(options, (String)"transport.");
            result.setTransportOption(transportOptions);
            return result;
        }
        catch (URISyntaxException e) {
            throw IOExceptionSupport.create((Exception)e);
        }
    }

    protected TextWireFormat asTextWireFormat(WireFormat wireFormat) {
        if (wireFormat instanceof TextWireFormat) {
            return (TextWireFormat)wireFormat;
        }
        LOG.trace("Not created with a TextWireFormat: {}", (Object)wireFormat);
        return new XStreamWireFormat();
    }

    protected String getDefaultWireFormatType() {
        return "xstream";
    }

    protected Transport createTransport(URI location, WireFormat wf) throws IOException {
        URI uri;
        TextWireFormat textWireFormat = this.asTextWireFormat(wf);
        try {
            uri = URISupport.removeQuery((URI)location);
        }
        catch (URISyntaxException e) {
            MalformedURLException cause = new MalformedURLException("Error removing query on " + location);
            cause.initCause(e);
            throw cause;
        }
        return new HttpClientTransport(textWireFormat, uri);
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        return this.compositeConfigure(transport, format, options);
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        boolean useInactivityMonitor;
        HttpClientTransport httpTransport = (HttpClientTransport)((Object)(transport = super.compositeConfigure(transport, format, options)).narrow(HttpClientTransport.class));
        if (httpTransport != null && httpTransport.isTrace()) {
            try {
                transport = TransportLoggerFactory.getInstance().createTransportLogger(transport);
            }
            catch (Throwable e) {
                LOG.error("Could not create TransportLogger object for: " + TransportLoggerFactory.defaultLogWriterName + ", reason: " + e, e);
            }
        }
        if (useInactivityMonitor = "true".equals(this.getOption(options, "useInactivityMonitor", "true"))) {
            transport = new HttpInactivityMonitor((Transport)transport);
            IntrospectionSupport.setProperties((Object)transport, (Map)options);
        }
        return transport;
    }
}

