/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.KeepAliveInfo;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportSupport;
import org.apache.activemq.transport.stomp.ProtocolConverter;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompTransport;
import org.apache.activemq.transport.stomp.StompWireFormat;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStompSocket
extends TransportSupport
implements StompTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStompSocket.class);
    protected ReentrantLock protocolLock = new ReentrantLock();
    protected ProtocolConverter protocolConverter = new ProtocolConverter((StompTransport)this, null);
    protected StompWireFormat wireFormat = new StompWireFormat();
    protected final CountDownLatch socketTransportStarted = new CountDownLatch(1);
    protected final StompInactivityMonitor stompInactivityMonitor = new StompInactivityMonitor((Transport)this, (WireFormat)this.wireFormat);
    protected volatile int receiveCounter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void oneway(Object command) throws IOException {
        this.protocolLock.lock();
        try {
            this.protocolConverter.onActiveMQCommand((Command)command);
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToActiveMQ(Command command) {
        this.protocolLock.lock();
        try {
            this.doConsume(command);
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    protected void doStop(ServiceStopper stopper) throws Exception {
        this.stompInactivityMonitor.stop();
        this.handleStopped();
    }

    protected void doStart() throws Exception {
        this.socketTransportStarted.countDown();
        this.stompInactivityMonitor.setTransportListener(this.getTransportListener());
        this.stompInactivityMonitor.startConnectCheckTask();
    }

    public abstract void sendToStomp(StompFrame var1) throws IOException;

    public abstract void handleStopped() throws IOException;

    public StompInactivityMonitor getInactivityMonitor() {
        return this.stompInactivityMonitor;
    }

    public StompWireFormat getWireFormat() {
        return this.wireFormat;
    }

    public String getRemoteAddress() {
        return "StompSocket_" + ((Object)((Object)this)).hashCode();
    }

    public int getReceiveCounter() {
        return this.receiveCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processStompFrame(String data) {
        if (!this.transportStartedAtLeastOnce()) {
            LOG.debug("Waiting for StompSocket to be properly started...");
            try {
                this.socketTransportStarted.await();
            }
            catch (InterruptedException e) {
                LOG.warn("While waiting for StompSocket to be properly started, we got interrupted!! Should be okay, but you could see race conditions...");
            }
        }
        this.protocolLock.lock();
        try {
            if (data != null) {
                this.receiveCounter += data.length();
                if (data.equals("\n")) {
                    this.stompInactivityMonitor.onCommand((Object)new KeepAliveInfo());
                } else {
                    this.protocolConverter.onStompCommand((StompFrame)this.wireFormat.unmarshal(new ByteSequence(data.getBytes("UTF-8"))));
                }
            }
        }
        catch (Exception e) {
            this.onException(IOExceptionSupport.create((Exception)e));
        }
        finally {
            this.protocolLock.unlock();
        }
    }

    private boolean transportStartedAtLeastOnce() {
        return this.socketTransportStarted.getCount() == 0L;
    }
}

