/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty8;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.ws.AbstractStompSocket;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StompSocket
extends AbstractStompSocket
implements WebSocket.OnTextMessage {
    private static final Logger LOG = LoggerFactory.getLogger(StompSocket.class);
    private final int ORDERLY_CLOSE_TIMEOUT = 10;
    private WebSocket.Connection outbound;

    StompSocket() {
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.outbound != null && this.outbound.isOpen()) {
            this.outbound.close();
        }
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        this.outbound.sendMessage(command.format());
    }

    public void onOpen(WebSocket.Connection connection) {
        this.outbound = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(int closeCode, String message) {
        try {
            if (this.protocolLock.tryLock() || this.protocolLock.tryLock(10L, TimeUnit.SECONDS)) {
                LOG.info("Stomp WebSocket closed: code[{}] message[{}]", (Object)closeCode, (Object)message);
                this.protocolConverter.onStompCommand(new StompFrame("DISCONNECT"));
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", (Throwable)e);
        }
        finally {
            if (this.protocolLock.isHeldByCurrentThread()) {
                this.protocolLock.unlock();
            }
        }
    }

    public void onMessage(String data) {
        this.processStompFrame(data);
    }
}

